// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An XML configuration specification for a WebTest. */
@Fluent
public final class WebTestPropertiesConfiguration {
    /*
     * The XML specification of a WebTest to run against an application.
     */
    @JsonProperty(value = "WebTest")
    private String webTest;

    /** Creates an instance of WebTestPropertiesConfiguration class. */
    public WebTestPropertiesConfiguration() {
    }

    /**
     * Get the webTest property: The XML specification of a WebTest to run against an application.
     *
     * @return the webTest value.
     */
    public String webTest() {
        return this.webTest;
    }

    /**
     * Set the webTest property: The XML specification of a WebTest to run against an application.
     *
     * @param webTest the webTest value to set.
     * @return the WebTestPropertiesConfiguration object itself.
     */
    public WebTestPropertiesConfiguration withWebTest(String webTest) {
        this.webTest = webTest;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
