// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The collection of content validation properties. */
@Fluent
public final class WebTestPropertiesValidationRulesContentValidation {
    /*
     * Content to look for in the return of the WebTest.  Must not be null or empty.
     */
    @JsonProperty(value = "ContentMatch")
    private String contentMatch;

    /*
     * When set, this value makes the ContentMatch validation case insensitive.
     */
    @JsonProperty(value = "IgnoreCase")
    private Boolean ignoreCase;

    /*
     * When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail
     * if there is a match
     */
    @JsonProperty(value = "PassIfTextFound")
    private Boolean passIfTextFound;

    /** Creates an instance of WebTestPropertiesValidationRulesContentValidation class. */
    public WebTestPropertiesValidationRulesContentValidation() {
    }

    /**
     * Get the contentMatch property: Content to look for in the return of the WebTest. Must not be null or empty.
     *
     * @return the contentMatch value.
     */
    public String contentMatch() {
        return this.contentMatch;
    }

    /**
     * Set the contentMatch property: Content to look for in the return of the WebTest. Must not be null or empty.
     *
     * @param contentMatch the contentMatch value to set.
     * @return the WebTestPropertiesValidationRulesContentValidation object itself.
     */
    public WebTestPropertiesValidationRulesContentValidation withContentMatch(String contentMatch) {
        this.contentMatch = contentMatch;
        return this;
    }

    /**
     * Get the ignoreCase property: When set, this value makes the ContentMatch validation case insensitive.
     *
     * @return the ignoreCase value.
     */
    public Boolean ignoreCase() {
        return this.ignoreCase;
    }

    /**
     * Set the ignoreCase property: When set, this value makes the ContentMatch validation case insensitive.
     *
     * @param ignoreCase the ignoreCase value to set.
     * @return the WebTestPropertiesValidationRulesContentValidation object itself.
     */
    public WebTestPropertiesValidationRulesContentValidation withIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    /**
     * Get the passIfTextFound property: When true, validation will pass if there is a match for the ContentMatch
     * string. If false, validation will fail if there is a match.
     *
     * @return the passIfTextFound value.
     */
    public Boolean passIfTextFound() {
        return this.passIfTextFound;
    }

    /**
     * Set the passIfTextFound property: When true, validation will pass if there is a match for the ContentMatch
     * string. If false, validation will fail if there is a match.
     *
     * @param passIfTextFound the passIfTextFound value to set.
     * @return the WebTestPropertiesValidationRulesContentValidation object itself.
     */
    public WebTestPropertiesValidationRulesContentValidation withPassIfTextFound(Boolean passIfTextFound) {
        this.passIfTextFound = passIfTextFound;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
