// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The parameters that can be provided when updating workbook template. */
@Fluent
public final class WorkbookTemplateUpdateParameters {
    /*
     * Resource tags
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * Metadata describing a workbook for an Azure resource.
     */
    @JsonProperty(value = "properties")
    private WorkbookTemplateProperties innerProperties;

    /** Creates an instance of WorkbookTemplateUpdateParameters class. */
    public WorkbookTemplateUpdateParameters() {
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: Metadata describing a workbook for an Azure resource.
     *
     * @return the innerProperties value.
     */
    private WorkbookTemplateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the priority property: Priority of the template. Determines which template to open when a workbook gallery is
     * opened in viewer mode.
     *
     * @return the priority value.
     */
    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    /**
     * Set the priority property: Priority of the template. Determines which template to open when a workbook gallery is
     * opened in viewer mode.
     *
     * @param priority the priority value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    /**
     * Get the author property: Information about the author of the workbook template.
     *
     * @return the author value.
     */
    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    /**
     * Set the author property: Information about the author of the workbook template.
     *
     * @param author the author value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withAuthor(String author) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withAuthor(author);
        return this;
    }

    /**
     * Get the templateData property: Valid JSON object containing workbook template payload.
     *
     * @return the templateData value.
     */
    public Object templateData() {
        return this.innerProperties() == null ? null : this.innerProperties().templateData();
    }

    /**
     * Set the templateData property: Valid JSON object containing workbook template payload.
     *
     * @param templateData the templateData value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withTemplateData(Object templateData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withTemplateData(templateData);
        return this;
    }

    /**
     * Get the galleries property: Workbook galleries supported by the template.
     *
     * @return the galleries value.
     */
    public List<WorkbookTemplateGallery> galleries() {
        return this.innerProperties() == null ? null : this.innerProperties().galleries();
    }

    /**
     * Set the galleries property: Workbook galleries supported by the template.
     *
     * @param galleries the galleries value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withGalleries(List<WorkbookTemplateGallery> galleries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withGalleries(galleries);
        return this;
    }

    /**
     * Get the localized property: Key value pair of localized gallery. Each key is the locale code of languages
     * supported by the Azure portal.
     *
     * @return the localized value.
     */
    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        return this.innerProperties() == null ? null : this.innerProperties().localized();
    }

    /**
     * Set the localized property: Key value pair of localized gallery. Each key is the locale code of languages
     * supported by the Azure portal.
     *
     * @param localized the localized value to set.
     * @return the WorkbookTemplateUpdateParameters object itself.
     */
    public WorkbookTemplateUpdateParameters withLocalized(
        Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withLocalized(localized);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
