// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** WorkbookTemplate list result. */
@Fluent
public final class WorkbookTemplatesListResult {
    /*
     * An array of workbook templates.
     */
    @JsonProperty(value = "value")
    private List<WorkbookTemplateInner> value;

    /** Creates an instance of WorkbookTemplatesListResult class. */
    public WorkbookTemplatesListResult() {
    }

    /**
     * Get the value property: An array of workbook templates.
     *
     * @return the value value.
     */
    public List<WorkbookTemplateInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of workbook templates.
     *
     * @param value the value value to set.
     * @return the WorkbookTemplatesListResult object itself.
     */
    public WorkbookTemplatesListResult withValue(List<WorkbookTemplateInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
