// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookPropertiesUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The parameters that can be provided when updating workbook properties properties. */
@Fluent
public final class WorkbookUpdateParameters {
    /*
     * The kind of workbook. Only valid value is shared.
     */
    @JsonProperty(value = "kind")
    private WorkbookUpdateSharedTypeKind kind;

    /*
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * Metadata describing a workbook for an Azure resource.
     */
    @JsonProperty(value = "properties")
    private WorkbookPropertiesUpdateParameters innerProperties;

    /** Creates an instance of WorkbookUpdateParameters class. */
    public WorkbookUpdateParameters() {
    }

    /**
     * Get the kind property: The kind of workbook. Only valid value is shared.
     *
     * @return the kind value.
     */
    public WorkbookUpdateSharedTypeKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The kind of workbook. Only valid value is shared.
     *
     * @param kind the kind value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withKind(WorkbookUpdateSharedTypeKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: Metadata describing a workbook for an Azure resource.
     *
     * @return the innerProperties value.
     */
    private WorkbookPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: The user-defined name (display name) of the workbook.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The user-defined name (display name) of the workbook.
     *
     * @param displayName the displayName value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the serializedData property: Configuration of this particular workbook. Configuration data is a string
     * containing valid JSON.
     *
     * @return the serializedData value.
     */
    public String serializedData() {
        return this.innerProperties() == null ? null : this.innerProperties().serializedData();
    }

    /**
     * Set the serializedData property: Configuration of this particular workbook. Configuration data is a string
     * containing valid JSON.
     *
     * @param serializedData the serializedData value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withSerializedData(String serializedData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withSerializedData(serializedData);
        return this;
    }

    /**
     * Get the category property: Workbook category, as defined by the user at creation time.
     *
     * @return the category value.
     */
    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    /**
     * Set the category property: Workbook category, as defined by the user at creation time.
     *
     * @param category the category value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    /**
     * Get the tags property: A list of 0 or more tags that are associated with this workbook definition.
     *
     * @return the tags value.
     */
    public List<String> tagsPropertiesTags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: A list of 0 or more tags that are associated with this workbook definition.
     *
     * @param tags the tags value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withTagsPropertiesTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the description property: The description of the workbook.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of the workbook.
     *
     * @param description the description value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the revision property: The unique revision id for this workbook definition.
     *
     * @return the revision value.
     */
    public String revision() {
        return this.innerProperties() == null ? null : this.innerProperties().revision();
    }

    /**
     * Set the revision property: The unique revision id for this workbook definition.
     *
     * @param revision the revision value to set.
     * @return the WorkbookUpdateParameters object itself.
     */
    public WorkbookUpdateParameters withRevision(String revision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withRevision(revision);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
