/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ProactiveDetectionConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentProactiveDetectionConfigurationInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentProactiveDetectionConfigurationImpl;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentProactiveDetectionConfiguration;
import com.azure.resourcemanager.applicationinsights.models.ProactiveDetectionConfigurations;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ProactiveDetectionConfigurationsImpl
implements ProactiveDetectionConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(ProactiveDetectionConfigurationsImpl.class);
    private final ProactiveDetectionConfigurationsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ProactiveDetectionConfigurationsImpl(ProactiveDetectionConfigurationsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<List<ApplicationInsightsComponentProactiveDetectionConfiguration>> listWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> inner = this.serviceClient().listWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new ApplicationInsightsComponentProactiveDetectionConfigurationImpl((ApplicationInsightsComponentProactiveDetectionConfigurationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public List<ApplicationInsightsComponentProactiveDetectionConfiguration> list(String resourceGroupName, String resourceName) {
        List<ApplicationInsightsComponentProactiveDetectionConfigurationInner> inner = this.serviceClient().list(resourceGroupName, resourceName);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new ApplicationInsightsComponentProactiveDetectionConfigurationImpl((ApplicationInsightsComponentProactiveDetectionConfigurationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<ApplicationInsightsComponentProactiveDetectionConfiguration> getWithResponse(String resourceGroupName, String resourceName, String configurationId, Context context) {
        Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, configurationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentProactiveDetectionConfigurationImpl((ApplicationInsightsComponentProactiveDetectionConfigurationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentProactiveDetectionConfiguration get(String resourceGroupName, String resourceName, String configurationId) {
        ApplicationInsightsComponentProactiveDetectionConfigurationInner inner = this.serviceClient().get(resourceGroupName, resourceName, configurationId);
        if (inner != null) {
            return new ApplicationInsightsComponentProactiveDetectionConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentProactiveDetectionConfiguration> updateWithResponse(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties, Context context) {
        Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentProactiveDetectionConfigurationImpl((ApplicationInsightsComponentProactiveDetectionConfigurationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentProactiveDetectionConfiguration update(String resourceGroupName, String resourceName, String configurationId, ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties) {
        ApplicationInsightsComponentProactiveDetectionConfigurationInner inner = this.serviceClient().update(resourceGroupName, resourceName, configurationId, proactiveDetectionProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentProactiveDetectionConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    private ProactiveDetectionConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

