/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.fluent.models.WebTestInner;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesRequest;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesValidationRules;
import java.util.List;
import java.util.Map;

public interface WebTest {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public WebTestKind kind();

    public String syntheticMonitorId();

    public String webTestName();

    public String description();

    public Boolean enabled();

    public Integer frequency();

    public Integer timeout();

    public WebTestKind webTestKind();

    public Boolean retryEnabled();

    public List<WebTestGeolocation> locations();

    public WebTestPropertiesConfiguration configuration();

    public String provisioningState();

    public WebTestPropertiesRequest request();

    public WebTestPropertiesValidationRules validationRules();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public WebTestInner innerModel();

    public Update update();

    public WebTest refresh();

    public WebTest refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public WebTest apply();

        public WebTest apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithValidationRules {
            public WithCreate withValidationRules(WebTestPropertiesValidationRules var1);
        }

        public static interface WithRequest {
            public WithCreate withRequest(WebTestPropertiesRequest var1);
        }

        public static interface WithConfiguration {
            public WithCreate withConfiguration(WebTestPropertiesConfiguration var1);
        }

        public static interface WithLocations {
            public WithCreate withLocations(List<WebTestGeolocation> var1);
        }

        public static interface WithRetryEnabled {
            public WithCreate withRetryEnabled(Boolean var1);
        }

        public static interface WithWebTestKind {
            public WithCreate withWebTestKind(WebTestKind var1);
        }

        public static interface WithTimeout {
            public WithCreate withTimeout(Integer var1);
        }

        public static interface WithFrequency {
            public WithCreate withFrequency(Integer var1);
        }

        public static interface WithEnabled {
            public WithCreate withEnabled(Boolean var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithWebTestName {
            public WithCreate withWebTestName(String var1);
        }

        public static interface WithSyntheticMonitorId {
            public WithCreate withSyntheticMonitorId(String var1);
        }

        public static interface WithKind {
            public WithCreate withKind(WebTestKind var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithKind,
        WithSyntheticMonitorId,
        WithWebTestName,
        WithDescription,
        WithEnabled,
        WithFrequency,
        WithTimeout,
        WithWebTestKind,
        WithRetryEnabled,
        WithLocations,
        WithConfiguration,
        WithRequest,
        WithValidationRules {
            public WebTest create();

            public WebTest create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

