/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnnotationInner
implements JsonSerializable<AnnotationInner> {
    private String annotationName;
    private String category;
    private OffsetDateTime eventTime;
    private String id;
    private String properties;
    private String relatedAnnotation;

    public String annotationName() {
        return this.annotationName;
    }

    public AnnotationInner withAnnotationName(String annotationName) {
        this.annotationName = annotationName;
        return this;
    }

    public String category() {
        return this.category;
    }

    public AnnotationInner withCategory(String category) {
        this.category = category;
        return this;
    }

    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    public AnnotationInner withEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public String id() {
        return this.id;
    }

    public AnnotationInner withId(String id) {
        this.id = id;
        return this;
    }

    public String properties() {
        return this.properties;
    }

    public AnnotationInner withProperties(String properties) {
        this.properties = properties;
        return this;
    }

    public String relatedAnnotation() {
        return this.relatedAnnotation;
    }

    public AnnotationInner withRelatedAnnotation(String relatedAnnotation) {
        this.relatedAnnotation = relatedAnnotation;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("AnnotationName", this.annotationName);
        jsonWriter.writeStringField("Category", this.category);
        jsonWriter.writeStringField("EventTime", this.eventTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.eventTime));
        jsonWriter.writeStringField("Id", this.id);
        jsonWriter.writeStringField("Properties", this.properties);
        jsonWriter.writeStringField("RelatedAnnotation", this.relatedAnnotation);
        return jsonWriter.writeEndObject();
    }

    public static AnnotationInner fromJson(JsonReader jsonReader) throws IOException {
        return (AnnotationInner)jsonReader.readObject(reader -> {
            AnnotationInner deserializedAnnotationInner = new AnnotationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("AnnotationName".equals(fieldName)) {
                    deserializedAnnotationInner.annotationName = reader.getString();
                    continue;
                }
                if ("Category".equals(fieldName)) {
                    deserializedAnnotationInner.category = reader.getString();
                    continue;
                }
                if ("EventTime".equals(fieldName)) {
                    deserializedAnnotationInner.eventTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("Id".equals(fieldName)) {
                    deserializedAnnotationInner.id = reader.getString();
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    deserializedAnnotationInner.properties = reader.getString();
                    continue;
                }
                if ("RelatedAnnotation".equals(fieldName)) {
                    deserializedAnnotationInner.relatedAnnotation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnnotationInner;
        });
    }
}

