/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentAnalyticsItemProperties;
import com.azure.resourcemanager.applicationinsights.models.ItemScope;
import com.azure.resourcemanager.applicationinsights.models.ItemType;
import java.io.IOException;

public final class ApplicationInsightsComponentAnalyticsItemInner
implements JsonSerializable<ApplicationInsightsComponentAnalyticsItemInner> {
    private String id;
    private String name;
    private String content;
    private String version;
    private ItemScope scope;
    private ItemType type;
    private String timeCreated;
    private String timeModified;
    private ApplicationInsightsComponentAnalyticsItemProperties properties;

    public String id() {
        return this.id;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withName(String name) {
        this.name = name;
        return this;
    }

    public String content() {
        return this.content;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withContent(String content) {
        this.content = content;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ItemScope scope() {
        return this.scope;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withScope(ItemScope scope) {
        this.scope = scope;
        return this;
    }

    public ItemType type() {
        return this.type;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withType(ItemType type) {
        this.type = type;
        return this;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public String timeModified() {
        return this.timeModified;
    }

    public ApplicationInsightsComponentAnalyticsItemProperties properties() {
        return this.properties;
    }

    public ApplicationInsightsComponentAnalyticsItemInner withProperties(ApplicationInsightsComponentAnalyticsItemProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Id", this.id);
        jsonWriter.writeStringField("Name", this.name);
        jsonWriter.writeStringField("Content", this.content);
        jsonWriter.writeStringField("Scope", this.scope == null ? null : this.scope.toString());
        jsonWriter.writeStringField("Type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("Properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInsightsComponentAnalyticsItemInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInsightsComponentAnalyticsItemInner)jsonReader.readObject(reader -> {
            ApplicationInsightsComponentAnalyticsItemInner deserializedApplicationInsightsComponentAnalyticsItemInner = new ApplicationInsightsComponentAnalyticsItemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Id".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.id = reader.getString();
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.name = reader.getString();
                    continue;
                }
                if ("Content".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.content = reader.getString();
                    continue;
                }
                if ("Version".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.version = reader.getString();
                    continue;
                }
                if ("Scope".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.scope = ItemScope.fromString(reader.getString());
                    continue;
                }
                if ("Type".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.type = ItemType.fromString(reader.getString());
                    continue;
                }
                if ("TimeCreated".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.timeCreated = reader.getString();
                    continue;
                }
                if ("TimeModified".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.timeModified = reader.getString();
                    continue;
                }
                if ("Properties".equals(fieldName)) {
                    deserializedApplicationInsightsComponentAnalyticsItemInner.properties = ApplicationInsightsComponentAnalyticsItemProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInsightsComponentAnalyticsItemInner;
        });
    }
}

