/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import java.io.IOException;
import java.util.List;

public final class ApplicationInsightsComponentFavoriteInner
implements JsonSerializable<ApplicationInsightsComponentFavoriteInner> {
    private String name;
    private String config;
    private String version;
    private String favoriteId;
    private FavoriteType favoriteType;
    private String sourceType;
    private String timeModified;
    private List<String> tags;
    private String category;
    private Boolean isGeneratedFromTemplate;
    private String userId;

    public String name() {
        return this.name;
    }

    public ApplicationInsightsComponentFavoriteInner withName(String name) {
        this.name = name;
        return this;
    }

    public String config() {
        return this.config;
    }

    public ApplicationInsightsComponentFavoriteInner withConfig(String config) {
        this.config = config;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ApplicationInsightsComponentFavoriteInner withVersion(String version) {
        this.version = version;
        return this;
    }

    public String favoriteId() {
        return this.favoriteId;
    }

    public FavoriteType favoriteType() {
        return this.favoriteType;
    }

    public ApplicationInsightsComponentFavoriteInner withFavoriteType(FavoriteType favoriteType) {
        this.favoriteType = favoriteType;
        return this;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public ApplicationInsightsComponentFavoriteInner withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public String timeModified() {
        return this.timeModified;
    }

    public List<String> tags() {
        return this.tags;
    }

    public ApplicationInsightsComponentFavoriteInner withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String category() {
        return this.category;
    }

    public ApplicationInsightsComponentFavoriteInner withCategory(String category) {
        this.category = category;
        return this;
    }

    public Boolean isGeneratedFromTemplate() {
        return this.isGeneratedFromTemplate;
    }

    public ApplicationInsightsComponentFavoriteInner withIsGeneratedFromTemplate(Boolean isGeneratedFromTemplate) {
        this.isGeneratedFromTemplate = isGeneratedFromTemplate;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Name", this.name);
        jsonWriter.writeStringField("Config", this.config);
        jsonWriter.writeStringField("Version", this.version);
        jsonWriter.writeStringField("FavoriteType", this.favoriteType == null ? null : this.favoriteType.toString());
        jsonWriter.writeStringField("SourceType", this.sourceType);
        jsonWriter.writeArrayField("Tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("Category", this.category);
        jsonWriter.writeBooleanField("IsGeneratedFromTemplate", this.isGeneratedFromTemplate);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInsightsComponentFavoriteInner fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInsightsComponentFavoriteInner)jsonReader.readObject(reader -> {
            ApplicationInsightsComponentFavoriteInner deserializedApplicationInsightsComponentFavoriteInner = new ApplicationInsightsComponentFavoriteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Name".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.name = reader.getString();
                    continue;
                }
                if ("Config".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.config = reader.getString();
                    continue;
                }
                if ("Version".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.version = reader.getString();
                    continue;
                }
                if ("FavoriteId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.favoriteId = reader.getString();
                    continue;
                }
                if ("FavoriteType".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.favoriteType = FavoriteType.fromString(reader.getString());
                    continue;
                }
                if ("SourceType".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.sourceType = reader.getString();
                    continue;
                }
                if ("TimeModified".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.timeModified = reader.getString();
                    continue;
                }
                if ("Tags".equals(fieldName)) {
                    List tags;
                    deserializedApplicationInsightsComponentFavoriteInner.tags = tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("Category".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.category = reader.getString();
                    continue;
                }
                if ("IsGeneratedFromTemplate".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.isGeneratedFromTemplate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("UserId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFavoriteInner.userId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInsightsComponentFavoriteInner;
        });
    }
}

