/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ApplicationInsightsComponentProperties
implements JsonSerializable<ApplicationInsightsComponentProperties> {
    private String applicationId;
    private String appId;
    private String name;
    private ApplicationType applicationType;
    private FlowType flowType;
    private RequestSource requestSource;
    private String instrumentationKey;
    private OffsetDateTime creationDate;
    private String tenantId;
    private String hockeyAppId;
    private String hockeyAppToken;
    private String provisioningState;
    private Double samplingPercentage;
    private String connectionString;
    private Integer retentionInDays;
    private Boolean disableIpMasking;
    private Boolean immediatePurgeDataOn30Days;
    private String workspaceResourceId;
    private OffsetDateTime laMigrationDate;
    private List<PrivateLinkScopedResource> privateLinkScopedResources;
    private PublicNetworkAccessType publicNetworkAccessForIngestion;
    private PublicNetworkAccessType publicNetworkAccessForQuery;
    private IngestionMode ingestionMode;
    private Boolean disableLocalAuth;
    private Boolean forceCustomerStorageForProfiler;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsComponentProperties.class);

    public String applicationId() {
        return this.applicationId;
    }

    public String appId() {
        return this.appId;
    }

    public String name() {
        return this.name;
    }

    public ApplicationType applicationType() {
        return this.applicationType;
    }

    public ApplicationInsightsComponentProperties withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public FlowType flowType() {
        return this.flowType;
    }

    public ApplicationInsightsComponentProperties withFlowType(FlowType flowType) {
        this.flowType = flowType;
        return this;
    }

    public RequestSource requestSource() {
        return this.requestSource;
    }

    public ApplicationInsightsComponentProperties withRequestSource(RequestSource requestSource) {
        this.requestSource = requestSource;
        return this;
    }

    public String instrumentationKey() {
        return this.instrumentationKey;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String hockeyAppId() {
        return this.hockeyAppId;
    }

    public ApplicationInsightsComponentProperties withHockeyAppId(String hockeyAppId) {
        this.hockeyAppId = hockeyAppId;
        return this;
    }

    public String hockeyAppToken() {
        return this.hockeyAppToken;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Double samplingPercentage() {
        return this.samplingPercentage;
    }

    public ApplicationInsightsComponentProperties withSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    public ApplicationInsightsComponentProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    public Boolean disableIpMasking() {
        return this.disableIpMasking;
    }

    public ApplicationInsightsComponentProperties withDisableIpMasking(Boolean disableIpMasking) {
        this.disableIpMasking = disableIpMasking;
        return this;
    }

    public Boolean immediatePurgeDataOn30Days() {
        return this.immediatePurgeDataOn30Days;
    }

    public ApplicationInsightsComponentProperties withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        this.immediatePurgeDataOn30Days = immediatePurgeDataOn30Days;
        return this;
    }

    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    public ApplicationInsightsComponentProperties withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public OffsetDateTime laMigrationDate() {
        return this.laMigrationDate;
    }

    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    public ApplicationInsightsComponentProperties withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    public ApplicationInsightsComponentProperties withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    public IngestionMode ingestionMode() {
        return this.ingestionMode;
    }

    public ApplicationInsightsComponentProperties withIngestionMode(IngestionMode ingestionMode) {
        this.ingestionMode = ingestionMode;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public ApplicationInsightsComponentProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean forceCustomerStorageForProfiler() {
        return this.forceCustomerStorageForProfiler;
    }

    public ApplicationInsightsComponentProperties withForceCustomerStorageForProfiler(Boolean forceCustomerStorageForProfiler) {
        this.forceCustomerStorageForProfiler = forceCustomerStorageForProfiler;
        return this;
    }

    public void validate() {
        if (this.applicationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property applicationType in model ApplicationInsightsComponentProperties"));
        }
        if (this.privateLinkScopedResources() != null) {
            this.privateLinkScopedResources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Application_Type", this.applicationType == null ? null : this.applicationType.toString());
        jsonWriter.writeStringField("Flow_Type", this.flowType == null ? null : this.flowType.toString());
        jsonWriter.writeStringField("Request_Source", this.requestSource == null ? null : this.requestSource.toString());
        jsonWriter.writeStringField("HockeyAppId", this.hockeyAppId);
        jsonWriter.writeNumberField("SamplingPercentage", (Number)this.samplingPercentage);
        jsonWriter.writeNumberField("RetentionInDays", (Number)this.retentionInDays);
        jsonWriter.writeBooleanField("DisableIpMasking", this.disableIpMasking);
        jsonWriter.writeBooleanField("ImmediatePurgeDataOn30Days", this.immediatePurgeDataOn30Days);
        jsonWriter.writeStringField("WorkspaceResourceId", this.workspaceResourceId);
        jsonWriter.writeStringField("publicNetworkAccessForIngestion", this.publicNetworkAccessForIngestion == null ? null : this.publicNetworkAccessForIngestion.toString());
        jsonWriter.writeStringField("publicNetworkAccessForQuery", this.publicNetworkAccessForQuery == null ? null : this.publicNetworkAccessForQuery.toString());
        jsonWriter.writeStringField("IngestionMode", this.ingestionMode == null ? null : this.ingestionMode.toString());
        jsonWriter.writeBooleanField("DisableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeBooleanField("ForceCustomerStorageForProfiler", this.forceCustomerStorageForProfiler);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInsightsComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInsightsComponentProperties)jsonReader.readObject(reader -> {
            ApplicationInsightsComponentProperties deserializedApplicationInsightsComponentProperties = new ApplicationInsightsComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Application_Type".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.applicationType = ApplicationType.fromString(reader.getString());
                    continue;
                }
                if ("ApplicationId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.applicationId = reader.getString();
                    continue;
                }
                if ("AppId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.appId = reader.getString();
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.name = reader.getString();
                    continue;
                }
                if ("Flow_Type".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.flowType = FlowType.fromString(reader.getString());
                    continue;
                }
                if ("Request_Source".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.requestSource = RequestSource.fromString(reader.getString());
                    continue;
                }
                if ("InstrumentationKey".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.instrumentationKey = reader.getString();
                    continue;
                }
                if ("CreationDate".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("TenantId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.tenantId = reader.getString();
                    continue;
                }
                if ("HockeyAppId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.hockeyAppId = reader.getString();
                    continue;
                }
                if ("HockeyAppToken".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.hockeyAppToken = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("SamplingPercentage".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.samplingPercentage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("ConnectionString".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.connectionString = reader.getString();
                    continue;
                }
                if ("RetentionInDays".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.retentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("DisableIpMasking".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.disableIpMasking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ImmediatePurgeDataOn30Days".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.immediatePurgeDataOn30Days = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("WorkspaceResourceId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.workspaceResourceId = reader.getString();
                    continue;
                }
                if ("LaMigrationDate".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.laMigrationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("PrivateLinkScopedResources".equals(fieldName)) {
                    List privateLinkScopedResources;
                    deserializedApplicationInsightsComponentProperties.privateLinkScopedResources = privateLinkScopedResources = reader.readArray(reader1 -> PrivateLinkScopedResource.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccessForIngestion".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.publicNetworkAccessForIngestion = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccessForQuery".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.publicNetworkAccessForQuery = PublicNetworkAccessType.fromString(reader.getString());
                    continue;
                }
                if ("IngestionMode".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.ingestionMode = IngestionMode.fromString(reader.getString());
                    continue;
                }
                if ("DisableLocalAuth".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ForceCustomerStorageForProfiler".equals(fieldName)) {
                    deserializedApplicationInsightsComponentProperties.forceCustomerStorageForProfiler = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInsightsComponentProperties;
        });
    }
}

