/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.MyWorkbookProperties;
import com.azure.resourcemanager.applicationinsights.models.Kind;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbookManagedIdentity;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbookResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MyWorkbookInner
extends MyWorkbookResource {
    private Kind kind;
    private MyWorkbookProperties innerProperties;
    private SystemData systemData;

    public Kind kind() {
        return this.kind;
    }

    public MyWorkbookInner withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    private MyWorkbookProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public MyWorkbookInner withIdentity(MyWorkbookManagedIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public MyWorkbookInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public MyWorkbookInner withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MyWorkbookInner withType(String type) {
        super.withType(type);
        return this;
    }

    @Override
    public MyWorkbookInner withEtag(Map<String, String> etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public MyWorkbookInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public MyWorkbookInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public MyWorkbookInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String serializedData() {
        return this.innerProperties() == null ? null : this.innerProperties().serializedData();
    }

    public MyWorkbookInner withSerializedData(String serializedData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withSerializedData(serializedData);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public MyWorkbookInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public MyWorkbookInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    public List<String> tagsPropertiesTags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public MyWorkbookInner withTagsPropertiesTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    public String sourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceId();
    }

    public MyWorkbookInner withSourceId(String sourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withSourceId(sourceId);
        return this;
    }

    public String storageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUri();
    }

    public MyWorkbookInner withStorageUri(String storageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MyWorkbookProperties();
        }
        this.innerProperties().withStorageUri(storageUri);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity());
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("type", this.type());
        jsonWriter.writeMapField("etag", this.etag(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MyWorkbookInner fromJson(JsonReader jsonReader) throws IOException {
        return (MyWorkbookInner)((Object)jsonReader.readObject(reader -> {
            MyWorkbookInner deserializedMyWorkbookInner = new MyWorkbookInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedMyWorkbookInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMyWorkbookInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMyWorkbookInner.withIdentity(MyWorkbookManagedIdentity.fromJson(reader));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMyWorkbookInner.withId(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMyWorkbookInner.withName(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMyWorkbookInner.withType(reader.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    Map etag = reader.readMap(reader1 -> reader1.getString());
                    deserializedMyWorkbookInner.withEtag(etag);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedMyWorkbookInner.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMyWorkbookInner.innerProperties = MyWorkbookProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedMyWorkbookInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMyWorkbookInner;
        }));
    }
}

