/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MyWorkbookProperties
implements JsonSerializable<MyWorkbookProperties> {
    private String displayName;
    private String serializedData;
    private String version;
    private String timeModified;
    private String category;
    private List<String> tags;
    private String userId;
    private String sourceId;
    private String storageUri;
    private static final ClientLogger LOGGER = new ClientLogger(MyWorkbookProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public MyWorkbookProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String serializedData() {
        return this.serializedData;
    }

    public MyWorkbookProperties withSerializedData(String serializedData) {
        this.serializedData = serializedData;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MyWorkbookProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String timeModified() {
        return this.timeModified;
    }

    public String category() {
        return this.category;
    }

    public MyWorkbookProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public MyWorkbookProperties withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public MyWorkbookProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public MyWorkbookProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model MyWorkbookProperties"));
        }
        if (this.serializedData() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serializedData in model MyWorkbookProperties"));
        }
        if (this.category() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property category in model MyWorkbookProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("serializedData", this.serializedData);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("sourceId", this.sourceId);
        jsonWriter.writeStringField("storageUri", this.storageUri);
        return jsonWriter.writeEndObject();
    }

    public static MyWorkbookProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MyWorkbookProperties)jsonReader.readObject(reader -> {
            MyWorkbookProperties deserializedMyWorkbookProperties = new MyWorkbookProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedMyWorkbookProperties.displayName = reader.getString();
                    continue;
                }
                if ("serializedData".equals(fieldName)) {
                    deserializedMyWorkbookProperties.serializedData = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedMyWorkbookProperties.category = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMyWorkbookProperties.version = reader.getString();
                    continue;
                }
                if ("timeModified".equals(fieldName)) {
                    deserializedMyWorkbookProperties.timeModified = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedMyWorkbookProperties.tags = tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMyWorkbookProperties.userId = reader.getString();
                    continue;
                }
                if ("sourceId".equals(fieldName)) {
                    deserializedMyWorkbookProperties.sourceId = reader.getString();
                    continue;
                }
                if ("storageUri".equals(fieldName)) {
                    deserializedMyWorkbookProperties.storageUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMyWorkbookProperties;
        });
    }
}

