/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WebTestProperties;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesRequest;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesValidationRules;
import com.azure.resourcemanager.applicationinsights.models.WebtestsResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebTestInner
extends WebtestsResource {
    private WebTestKind kind;
    private WebTestProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public WebTestKind kind() {
        return this.kind;
    }

    public WebTestInner withKind(WebTestKind kind) {
        this.kind = kind;
        return this;
    }

    private WebTestProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WebTestInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public WebTestInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String syntheticMonitorId() {
        return this.innerProperties() == null ? null : this.innerProperties().syntheticMonitorId();
    }

    public WebTestInner withSyntheticMonitorId(String syntheticMonitorId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withSyntheticMonitorId(syntheticMonitorId);
        return this;
    }

    public String webTestName() {
        return this.innerProperties() == null ? null : this.innerProperties().webTestName();
    }

    public WebTestInner withWebTestName(String webTestName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withWebTestName(webTestName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WebTestInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public WebTestInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public Integer frequency() {
        return this.innerProperties() == null ? null : this.innerProperties().frequency();
    }

    public WebTestInner withFrequency(Integer frequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withFrequency(frequency);
        return this;
    }

    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    public WebTestInner withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    public WebTestKind webTestKind() {
        return this.innerProperties() == null ? null : this.innerProperties().webTestKind();
    }

    public WebTestInner withWebTestKind(WebTestKind webTestKind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withWebTestKind(webTestKind);
        return this;
    }

    public Boolean retryEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().retryEnabled();
    }

    public WebTestInner withRetryEnabled(Boolean retryEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withRetryEnabled(retryEnabled);
        return this;
    }

    public List<WebTestGeolocation> locations() {
        return this.innerProperties() == null ? null : this.innerProperties().locations();
    }

    public WebTestInner withLocations(List<WebTestGeolocation> locations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withLocations(locations);
        return this;
    }

    public WebTestPropertiesConfiguration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public WebTestInner withConfiguration(WebTestPropertiesConfiguration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public WebTestPropertiesRequest request() {
        return this.innerProperties() == null ? null : this.innerProperties().request();
    }

    public WebTestInner withRequest(WebTestPropertiesRequest request) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withRequest(request);
        return this;
    }

    public WebTestPropertiesValidationRules validationRules() {
        return this.innerProperties() == null ? null : this.innerProperties().validationRules();
    }

    public WebTestInner withValidationRules(WebTestPropertiesValidationRules validationRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebTestProperties();
        }
        this.innerProperties().withValidationRules(validationRules);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebTestInner fromJson(JsonReader jsonReader) throws IOException {
        return (WebTestInner)((Object)jsonReader.readObject(reader -> {
            WebTestInner deserializedWebTestInner = new WebTestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWebTestInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebTestInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebTestInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWebTestInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWebTestInner.withTags(tags);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWebTestInner.kind = WebTestKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebTestInner.innerProperties = WebTestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebTestInner;
        }));
    }
}

