/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesRequest;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesValidationRules;
import java.io.IOException;
import java.util.List;

public final class WebTestProperties
implements JsonSerializable<WebTestProperties> {
    private String syntheticMonitorId;
    private String webTestName;
    private String description;
    private Boolean enabled;
    private Integer frequency;
    private Integer timeout;
    private WebTestKind webTestKind;
    private Boolean retryEnabled;
    private List<WebTestGeolocation> locations;
    private WebTestPropertiesConfiguration configuration;
    private String provisioningState;
    private WebTestPropertiesRequest request;
    private WebTestPropertiesValidationRules validationRules;
    private static final ClientLogger LOGGER = new ClientLogger(WebTestProperties.class);

    public String syntheticMonitorId() {
        return this.syntheticMonitorId;
    }

    public WebTestProperties withSyntheticMonitorId(String syntheticMonitorId) {
        this.syntheticMonitorId = syntheticMonitorId;
        return this;
    }

    public String webTestName() {
        return this.webTestName;
    }

    public WebTestProperties withWebTestName(String webTestName) {
        this.webTestName = webTestName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WebTestProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public WebTestProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public WebTestProperties withFrequency(Integer frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public WebTestProperties withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public WebTestKind webTestKind() {
        return this.webTestKind;
    }

    public WebTestProperties withWebTestKind(WebTestKind webTestKind) {
        this.webTestKind = webTestKind;
        return this;
    }

    public Boolean retryEnabled() {
        return this.retryEnabled;
    }

    public WebTestProperties withRetryEnabled(Boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
        return this;
    }

    public List<WebTestGeolocation> locations() {
        return this.locations;
    }

    public WebTestProperties withLocations(List<WebTestGeolocation> locations) {
        this.locations = locations;
        return this;
    }

    public WebTestPropertiesConfiguration configuration() {
        return this.configuration;
    }

    public WebTestProperties withConfiguration(WebTestPropertiesConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public WebTestPropertiesRequest request() {
        return this.request;
    }

    public WebTestProperties withRequest(WebTestPropertiesRequest request) {
        this.request = request;
        return this;
    }

    public WebTestPropertiesValidationRules validationRules() {
        return this.validationRules;
    }

    public WebTestProperties withValidationRules(WebTestPropertiesValidationRules validationRules) {
        this.validationRules = validationRules;
        return this;
    }

    public void validate() {
        if (this.syntheticMonitorId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property syntheticMonitorId in model WebTestProperties"));
        }
        if (this.webTestName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property webTestName in model WebTestProperties"));
        }
        if (this.webTestKind() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property webTestKind in model WebTestProperties"));
        }
        if (this.locations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property locations in model WebTestProperties"));
        }
        this.locations().forEach(e -> e.validate());
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.validationRules() != null) {
            this.validationRules().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("SyntheticMonitorId", this.syntheticMonitorId);
        jsonWriter.writeStringField("Name", this.webTestName);
        jsonWriter.writeStringField("Kind", this.webTestKind == null ? null : this.webTestKind.toString());
        jsonWriter.writeArrayField("Locations", this.locations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("Description", this.description);
        jsonWriter.writeBooleanField("Enabled", this.enabled);
        jsonWriter.writeNumberField("Frequency", (Number)this.frequency);
        jsonWriter.writeNumberField("Timeout", (Number)this.timeout);
        jsonWriter.writeBooleanField("RetryEnabled", this.retryEnabled);
        jsonWriter.writeJsonField("Configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeJsonField("Request", (JsonSerializable)this.request);
        jsonWriter.writeJsonField("ValidationRules", (JsonSerializable)this.validationRules);
        return jsonWriter.writeEndObject();
    }

    public static WebTestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebTestProperties)jsonReader.readObject(reader -> {
            WebTestProperties deserializedWebTestProperties = new WebTestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("SyntheticMonitorId".equals(fieldName)) {
                    deserializedWebTestProperties.syntheticMonitorId = reader.getString();
                    continue;
                }
                if ("Name".equals(fieldName)) {
                    deserializedWebTestProperties.webTestName = reader.getString();
                    continue;
                }
                if ("Kind".equals(fieldName)) {
                    deserializedWebTestProperties.webTestKind = WebTestKind.fromString(reader.getString());
                    continue;
                }
                if ("Locations".equals(fieldName)) {
                    List locations;
                    deserializedWebTestProperties.locations = locations = reader.readArray(reader1 -> WebTestGeolocation.fromJson(reader1));
                    continue;
                }
                if ("Description".equals(fieldName)) {
                    deserializedWebTestProperties.description = reader.getString();
                    continue;
                }
                if ("Enabled".equals(fieldName)) {
                    deserializedWebTestProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("Frequency".equals(fieldName)) {
                    deserializedWebTestProperties.frequency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("Timeout".equals(fieldName)) {
                    deserializedWebTestProperties.timeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("RetryEnabled".equals(fieldName)) {
                    deserializedWebTestProperties.retryEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("Configuration".equals(fieldName)) {
                    deserializedWebTestProperties.configuration = WebTestPropertiesConfiguration.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedWebTestProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("Request".equals(fieldName)) {
                    deserializedWebTestProperties.request = WebTestPropertiesRequest.fromJson(reader);
                    continue;
                }
                if ("ValidationRules".equals(fieldName)) {
                    deserializedWebTestProperties.validationRules = WebTestPropertiesValidationRules.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebTestProperties;
        });
    }
}

