/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookProperties;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResource;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResourceIdentity;
import com.azure.resourcemanager.applicationinsights.models.WorkbookSharedTypeKind;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class WorkbookInner
extends WorkbookResource {
    private WorkbookProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private WorkbookProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WorkbookInner withIdentity(WorkbookResourceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    @Override
    public WorkbookInner withKind(WorkbookSharedTypeKind kind) {
        super.withKind(kind);
        return this;
    }

    @Override
    public WorkbookInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public WorkbookInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public WorkbookInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public WorkbookInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String serializedData() {
        return this.innerProperties() == null ? null : this.innerProperties().serializedData();
    }

    public WorkbookInner withSerializedData(String serializedData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withSerializedData(serializedData);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public WorkbookInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public OffsetDateTime timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public WorkbookInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    public List<String> tagsPropertiesTags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public WorkbookInner withTagsPropertiesTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    public String sourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceId();
    }

    public WorkbookInner withSourceId(String sourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withSourceId(sourceId);
        return this;
    }

    public String storageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUri();
    }

    public WorkbookInner withStorageUri(String storageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withStorageUri(storageUri);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WorkbookInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String revision() {
        return this.innerProperties() == null ? null : this.innerProperties().revision();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity());
        jsonWriter.writeStringField("kind", this.kind() == null ? null : this.kind().toString());
        jsonWriter.writeStringField("etag", this.etag());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookInner)((Object)jsonReader.readObject(reader -> {
            WorkbookInner deserializedWorkbookInner = new WorkbookInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkbookInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkbookInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkbookInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkbookInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkbookInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkbookInner.withIdentity(WorkbookResourceIdentity.fromJson(reader));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkbookInner.withKind(WorkbookSharedTypeKind.fromString(reader.getString()));
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWorkbookInner.withEtag(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkbookInner.innerProperties = WorkbookProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedWorkbookInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookInner;
        }));
    }
}

