/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class WorkbookProperties
implements JsonSerializable<WorkbookProperties> {
    private String displayName;
    private String serializedData;
    private String version;
    private OffsetDateTime timeModified;
    private String category;
    private List<String> tags;
    private String userId;
    private String sourceId;
    private String storageUri;
    private String description;
    private String revision;
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public WorkbookProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String serializedData() {
        return this.serializedData;
    }

    public WorkbookProperties withSerializedData(String serializedData) {
        this.serializedData = serializedData;
        return this;
    }

    public String version() {
        return this.version;
    }

    public WorkbookProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime timeModified() {
        return this.timeModified;
    }

    public String category() {
        return this.category;
    }

    public WorkbookProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public WorkbookProperties withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public WorkbookProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public WorkbookProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WorkbookProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String revision() {
        return this.revision;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property displayName in model WorkbookProperties"));
        }
        if (this.serializedData() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serializedData in model WorkbookProperties"));
        }
        if (this.category() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property category in model WorkbookProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("serializedData", this.serializedData);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("sourceId", this.sourceId);
        jsonWriter.writeStringField("storageUri", this.storageUri);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookProperties)jsonReader.readObject(reader -> {
            WorkbookProperties deserializedWorkbookProperties = new WorkbookProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedWorkbookProperties.displayName = reader.getString();
                    continue;
                }
                if ("serializedData".equals(fieldName)) {
                    deserializedWorkbookProperties.serializedData = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedWorkbookProperties.category = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedWorkbookProperties.version = reader.getString();
                    continue;
                }
                if ("timeModified".equals(fieldName)) {
                    deserializedWorkbookProperties.timeModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedWorkbookProperties.tags = tags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedWorkbookProperties.userId = reader.getString();
                    continue;
                }
                if ("sourceId".equals(fieldName)) {
                    deserializedWorkbookProperties.sourceId = reader.getString();
                    continue;
                }
                if ("storageUri".equals(fieldName)) {
                    deserializedWorkbookProperties.storageUri = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedWorkbookProperties.description = reader.getString();
                    continue;
                }
                if ("revision".equals(fieldName)) {
                    deserializedWorkbookProperties.revision = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookProperties;
        });
    }
}

