/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateProperties;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateResource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkbookTemplateInner
extends WorkbookTemplateResource {
    private WorkbookTemplateProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private WorkbookTemplateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public WorkbookTemplateInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public WorkbookTemplateInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public WorkbookTemplateInner withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    public WorkbookTemplateInner withAuthor(String author) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withAuthor(author);
        return this;
    }

    public Object templateData() {
        return this.innerProperties() == null ? null : this.innerProperties().templateData();
    }

    public WorkbookTemplateInner withTemplateData(Object templateData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withTemplateData(templateData);
        return this;
    }

    public List<WorkbookTemplateGallery> galleries() {
        return this.innerProperties() == null ? null : this.innerProperties().galleries();
    }

    public WorkbookTemplateInner withGalleries(List<WorkbookTemplateGallery> galleries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withGalleries(galleries);
        return this;
    }

    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        return this.innerProperties() == null ? null : this.innerProperties().localized();
    }

    public WorkbookTemplateInner withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withLocalized(localized);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookTemplateInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookTemplateInner)((Object)jsonReader.readObject(reader -> {
            WorkbookTemplateInner deserializedWorkbookTemplateInner = new WorkbookTemplateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkbookTemplateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkbookTemplateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkbookTemplateInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkbookTemplateInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkbookTemplateInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkbookTemplateInner.innerProperties = WorkbookTemplateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookTemplateInner;
        }));
    }
}

