/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkbookTemplateProperties
implements JsonSerializable<WorkbookTemplateProperties> {
    private Integer priority;
    private String author;
    private Object templateData;
    private List<WorkbookTemplateGallery> galleries;
    private Map<String, List<WorkbookTemplateLocalizedGallery>> localized;
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookTemplateProperties.class);

    public Integer priority() {
        return this.priority;
    }

    public WorkbookTemplateProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public String author() {
        return this.author;
    }

    public WorkbookTemplateProperties withAuthor(String author) {
        this.author = author;
        return this;
    }

    public Object templateData() {
        return this.templateData;
    }

    public WorkbookTemplateProperties withTemplateData(Object templateData) {
        this.templateData = templateData;
        return this;
    }

    public List<WorkbookTemplateGallery> galleries() {
        return this.galleries;
    }

    public WorkbookTemplateProperties withGalleries(List<WorkbookTemplateGallery> galleries) {
        this.galleries = galleries;
        return this;
    }

    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        return this.localized;
    }

    public WorkbookTemplateProperties withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        this.localized = localized;
        return this;
    }

    public void validate() {
        if (this.templateData() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property templateData in model WorkbookTemplateProperties"));
        }
        if (this.galleries() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property galleries in model WorkbookTemplateProperties"));
        }
        this.galleries().forEach(e -> e.validate());
        if (this.localized() != null) {
            this.localized().values().forEach(e -> {
                if (e != null) {
                    e.forEach(e1 -> e1.validate());
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("templateData", this.templateData);
        jsonWriter.writeArrayField("galleries", this.galleries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeStringField("author", this.author);
        jsonWriter.writeMapField("localized", this.localized, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        return jsonWriter.writeEndObject();
    }

    public static WorkbookTemplateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookTemplateProperties)jsonReader.readObject(reader -> {
            WorkbookTemplateProperties deserializedWorkbookTemplateProperties = new WorkbookTemplateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("templateData".equals(fieldName)) {
                    deserializedWorkbookTemplateProperties.templateData = reader.readUntyped();
                    continue;
                }
                if ("galleries".equals(fieldName)) {
                    List galleries;
                    deserializedWorkbookTemplateProperties.galleries = galleries = reader.readArray(reader1 -> WorkbookTemplateGallery.fromJson(reader1));
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedWorkbookTemplateProperties.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("author".equals(fieldName)) {
                    deserializedWorkbookTemplateProperties.author = reader.getString();
                    continue;
                }
                if ("localized".equals(fieldName)) {
                    Map localized;
                    deserializedWorkbookTemplateProperties.localized = localized = reader.readMap(reader1 -> reader1.readArray(reader2 -> WorkbookTemplateLocalizedGallery.fromJson(reader2)));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookTemplateProperties;
        });
    }
}

