/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentInner;
import com.azure.resourcemanager.applicationinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponent;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeBody;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeResponse;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import com.azure.resourcemanager.applicationinsights.models.TagsResource;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ApplicationInsightsComponentImpl
implements ApplicationInsightsComponent,
ApplicationInsightsComponent.Definition,
ApplicationInsightsComponent.Update {
    private ApplicationInsightsComponentInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private TagsResource updateComponentTags;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String applicationId() {
        return this.innerModel().applicationId();
    }

    @Override
    public String appId() {
        return this.innerModel().appId();
    }

    @Override
    public String namePropertiesName() {
        return this.innerModel().namePropertiesName();
    }

    @Override
    public ApplicationType applicationType() {
        return this.innerModel().applicationType();
    }

    @Override
    public FlowType flowType() {
        return this.innerModel().flowType();
    }

    @Override
    public RequestSource requestSource() {
        return this.innerModel().requestSource();
    }

    @Override
    public String instrumentationKey() {
        return this.innerModel().instrumentationKey();
    }

    @Override
    public OffsetDateTime creationDate() {
        return this.innerModel().creationDate();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public String hockeyAppId() {
        return this.innerModel().hockeyAppId();
    }

    @Override
    public String hockeyAppToken() {
        return this.innerModel().hockeyAppToken();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Double samplingPercentage() {
        return this.innerModel().samplingPercentage();
    }

    @Override
    public String connectionString() {
        return this.innerModel().connectionString();
    }

    @Override
    public Integer retentionInDays() {
        return this.innerModel().retentionInDays();
    }

    @Override
    public Boolean disableIpMasking() {
        return this.innerModel().disableIpMasking();
    }

    @Override
    public Boolean immediatePurgeDataOn30Days() {
        return this.innerModel().immediatePurgeDataOn30Days();
    }

    @Override
    public String workspaceResourceId() {
        return this.innerModel().workspaceResourceId();
    }

    @Override
    public OffsetDateTime laMigrationDate() {
        return this.innerModel().laMigrationDate();
    }

    @Override
    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        List<PrivateLinkScopedResource> inner = this.innerModel().privateLinkScopedResources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.innerModel().publicNetworkAccessForIngestion();
    }

    @Override
    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.innerModel().publicNetworkAccessForQuery();
    }

    @Override
    public IngestionMode ingestionMode() {
        return this.innerModel().ingestionMode();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public Boolean forceCustomerStorageForProfiler() {
        return this.innerModel().forceCustomerStorageForProfiler();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ApplicationInsightsComponentInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationInsightsComponentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ApplicationInsightsComponent create() {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ApplicationInsightsComponent create(Context context) {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationInsightsComponentImpl(String name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new ApplicationInsightsComponentInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
    }

    @Override
    public ApplicationInsightsComponentImpl update() {
        this.updateComponentTags = new TagsResource();
        return this;
    }

    @Override
    public ApplicationInsightsComponent apply() {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().updateTagsWithResponse(this.resourceGroupName, this.resourceName, this.updateComponentTags, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApplicationInsightsComponent apply(Context context) {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().updateTagsWithResponse(this.resourceGroupName, this.resourceName, this.updateComponentTags, context).getValue());
        return this;
    }

    ApplicationInsightsComponentImpl(ApplicationInsightsComponentInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "components");
    }

    @Override
    public ApplicationInsightsComponent refresh() {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ApplicationInsightsComponent refresh(Context context) {
        this.innerObject = (ApplicationInsightsComponentInner)((Object)this.serviceManager.serviceClient().getComponents().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, context).getValue());
        return this;
    }

    @Override
    public Response<ComponentPurgeResponse> purgeWithResponse(ComponentPurgeBody body, Context context) {
        return this.serviceManager.components().purgeWithResponse(this.resourceGroupName, this.resourceName, body, context);
    }

    @Override
    public ComponentPurgeResponse purge(ComponentPurgeBody body) {
        return this.serviceManager.components().purge(this.resourceGroupName, this.resourceName, body);
    }

    @Override
    public ApplicationInsightsComponentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withKind(String kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateComponentTags.withTags(tags);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withApplicationType(ApplicationType applicationType) {
        this.innerModel().withApplicationType(applicationType);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withFlowType(FlowType flowType) {
        this.innerModel().withFlowType(flowType);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withRequestSource(RequestSource requestSource) {
        this.innerModel().withRequestSource(requestSource);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withHockeyAppId(String hockeyAppId) {
        this.innerModel().withHockeyAppId(hockeyAppId);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withSamplingPercentage(Double samplingPercentage) {
        this.innerModel().withSamplingPercentage(samplingPercentage);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withRetentionInDays(Integer retentionInDays) {
        this.innerModel().withRetentionInDays(retentionInDays);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withDisableIpMasking(Boolean disableIpMasking) {
        this.innerModel().withDisableIpMasking(disableIpMasking);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        this.innerModel().withImmediatePurgeDataOn30Days(immediatePurgeDataOn30Days);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withWorkspaceResourceId(String workspaceResourceId) {
        this.innerModel().withWorkspaceResourceId(workspaceResourceId);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withPublicNetworkAccessForIngestion(PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.innerModel().withPublicNetworkAccessForIngestion(publicNetworkAccessForIngestion);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withPublicNetworkAccessForQuery(PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.innerModel().withPublicNetworkAccessForQuery(publicNetworkAccessForQuery);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withIngestionMode(IngestionMode ingestionMode) {
        this.innerModel().withIngestionMode(ingestionMode);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        this.innerModel().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    @Override
    public ApplicationInsightsComponentImpl withForceCustomerStorageForProfiler(Boolean forceCustomerStorageForProfiler) {
        this.innerModel().withForceCustomerStorageForProfiler(forceCustomerStorageForProfiler);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

