/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.MyWorkbookInner;
import com.azure.resourcemanager.applicationinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.applicationinsights.models.Kind;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbook;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbookManagedIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MyWorkbookImpl
implements MyWorkbook,
MyWorkbook.Definition,
MyWorkbook.Update {
    private MyWorkbookInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String createSourceId;
    private String updateSourceId;

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public MyWorkbookManagedIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, String> etag() {
        Map<String, String> inner = this.innerModel().etag();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Kind kind() {
        return this.innerModel().kind();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String serializedData() {
        return this.innerModel().serializedData();
    }

    @Override
    public String version() {
        return this.innerModel().version();
    }

    @Override
    public String timeModified() {
        return this.innerModel().timeModified();
    }

    @Override
    public String category() {
        return this.innerModel().category();
    }

    @Override
    public List<String> tagsPropertiesTags() {
        List<String> inner = this.innerModel().tagsPropertiesTags();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String userId() {
        return this.innerModel().userId();
    }

    @Override
    public String sourceId() {
        return this.innerModel().sourceId();
    }

    @Override
    public String storageUri() {
        return this.innerModel().storageUri();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MyWorkbookInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public MyWorkbookImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public MyWorkbook create() {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.createSourceId, Context.NONE).getValue());
        return this;
    }

    @Override
    public MyWorkbook create(Context context) {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.createSourceId, context).getValue());
        return this;
    }

    MyWorkbookImpl(String name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new MyWorkbookInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
        this.createSourceId = null;
    }

    @Override
    public MyWorkbookImpl update() {
        this.updateSourceId = null;
        return this;
    }

    @Override
    public MyWorkbook apply() {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().updateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.updateSourceId, Context.NONE).getValue());
        return this;
    }

    @Override
    public MyWorkbook apply(Context context) {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().updateWithResponse(this.resourceGroupName, this.resourceName, this.innerModel(), this.updateSourceId, context).getValue());
        return this;
    }

    MyWorkbookImpl(MyWorkbookInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "myWorkbooks");
    }

    @Override
    public MyWorkbook refresh() {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MyWorkbook refresh(Context context) {
        this.innerObject = (MyWorkbookInner)((Object)this.serviceManager.serviceClient().getMyWorkbooks().getByResourceGroupWithResponse(this.resourceGroupName, this.resourceName, context).getValue());
        return this;
    }

    @Override
    public MyWorkbookImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public MyWorkbookImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public MyWorkbookImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public MyWorkbookImpl withIdentity(MyWorkbookManagedIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public MyWorkbookImpl withName(String name) {
        this.innerModel().withName(name);
        return this;
    }

    @Override
    public MyWorkbookImpl withType(String type) {
        this.innerModel().withType(type);
        return this;
    }

    @Override
    public MyWorkbookImpl withEtag(Map<String, String> etag) {
        this.innerModel().withEtag((Map)etag);
        return this;
    }

    @Override
    public MyWorkbookImpl withKind(Kind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public MyWorkbookImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public MyWorkbookImpl withSerializedData(String serializedData) {
        this.innerModel().withSerializedData(serializedData);
        return this;
    }

    @Override
    public MyWorkbookImpl withVersion(String version) {
        this.innerModel().withVersion(version);
        return this;
    }

    @Override
    public MyWorkbookImpl withCategory(String category) {
        this.innerModel().withCategory(category);
        return this;
    }

    @Override
    public MyWorkbookImpl withTagsPropertiesTags(List<String> tagsPropertiesTags) {
        this.innerModel().withTagsPropertiesTags(tagsPropertiesTags);
        return this;
    }

    @Override
    public MyWorkbookImpl withSourceId(String sourceId) {
        this.innerModel().withSourceId(sourceId);
        return this;
    }

    @Override
    public MyWorkbookImpl withStorageUri(String storageUri) {
        this.innerModel().withStorageUri(storageUri);
        return this;
    }

    @Override
    public MyWorkbookImpl withSourceIdParameter(String sourceId) {
        if (this.isInCreateMode()) {
            this.createSourceId = sourceId;
            return this;
        }
        this.updateSourceId = sourceId;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

