/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.WorkbookTemplatesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateInner;
import com.azure.resourcemanager.applicationinsights.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.applicationinsights.implementation.WorkbookTemplateImpl;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplate;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplates;

public final class WorkbookTemplatesImpl
implements WorkbookTemplates {
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookTemplatesImpl.class);
    private final WorkbookTemplatesClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public WorkbookTemplatesImpl(WorkbookTemplatesClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<WorkbookTemplate> listByResourceGroup(String resourceGroupName) {
        PagedIterable<WorkbookTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkbookTemplateImpl((WorkbookTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WorkbookTemplate> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<WorkbookTemplateInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkbookTemplateImpl((WorkbookTemplateInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<WorkbookTemplate> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<WorkbookTemplateInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkbookTemplateImpl((WorkbookTemplateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public WorkbookTemplate getByResourceGroup(String resourceGroupName, String resourceName) {
        WorkbookTemplateInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceName);
        if (inner != null) {
            return new WorkbookTemplateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String resourceName) {
        this.serviceClient().delete(resourceGroupName, resourceName);
    }

    @Override
    public WorkbookTemplate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = ResourceManagerUtils.getValueFromIdByName(id, "workbooktemplates");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooktemplates'.", id)));
        }
        return (WorkbookTemplate)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @Override
    public Response<WorkbookTemplate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = ResourceManagerUtils.getValueFromIdByName(id, "workbooktemplates");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooktemplates'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = ResourceManagerUtils.getValueFromIdByName(id, "workbooktemplates");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooktemplates'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = ResourceManagerUtils.getValueFromIdByName(id, "workbooktemplates");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workbooktemplates'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, resourceName, context);
    }

    private WorkbookTemplatesClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkbookTemplateImpl define(String name) {
        return new WorkbookTemplateImpl(name, this.manager());
    }
}

