/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ApiKeyRequest
implements JsonSerializable<ApiKeyRequest> {
    private String name;
    private List<String> linkedReadProperties;
    private List<String> linkedWriteProperties;

    public String name() {
        return this.name;
    }

    public ApiKeyRequest withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> linkedReadProperties() {
        return this.linkedReadProperties;
    }

    public ApiKeyRequest withLinkedReadProperties(List<String> linkedReadProperties) {
        this.linkedReadProperties = linkedReadProperties;
        return this;
    }

    public List<String> linkedWriteProperties() {
        return this.linkedWriteProperties;
    }

    public ApiKeyRequest withLinkedWriteProperties(List<String> linkedWriteProperties) {
        this.linkedWriteProperties = linkedWriteProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("linkedReadProperties", this.linkedReadProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("linkedWriteProperties", this.linkedWriteProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApiKeyRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ApiKeyRequest)jsonReader.readObject(reader -> {
            ApiKeyRequest deserializedApiKeyRequest = new ApiKeyRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApiKeyRequest.name = reader.getString();
                    continue;
                }
                if ("linkedReadProperties".equals(fieldName)) {
                    List linkedReadProperties;
                    deserializedApiKeyRequest.linkedReadProperties = linkedReadProperties = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("linkedWriteProperties".equals(fieldName)) {
                    List linkedWriteProperties;
                    deserializedApiKeyRequest.linkedWriteProperties = linkedWriteProperties = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiKeyRequest;
        });
    }
}

