/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFeatureCapability;
import java.io.IOException;
import java.util.List;

public final class ApplicationInsightsComponentFeature
implements JsonSerializable<ApplicationInsightsComponentFeature> {
    private String featureName;
    private String meterId;
    private String meterRateFrequency;
    private String resouceId;
    private Boolean isHidden;
    private List<ApplicationInsightsComponentFeatureCapability> capabilities;
    private String title;
    private Boolean isMainFeature;
    private String supportedAddonFeatures;

    public String featureName() {
        return this.featureName;
    }

    public String meterId() {
        return this.meterId;
    }

    public String meterRateFrequency() {
        return this.meterRateFrequency;
    }

    public String resouceId() {
        return this.resouceId;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public List<ApplicationInsightsComponentFeatureCapability> capabilities() {
        return this.capabilities;
    }

    public String title() {
        return this.title;
    }

    public Boolean isMainFeature() {
        return this.isMainFeature;
    }

    public String supportedAddonFeatures() {
        return this.supportedAddonFeatures;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInsightsComponentFeature fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInsightsComponentFeature)jsonReader.readObject(reader -> {
            ApplicationInsightsComponentFeature deserializedApplicationInsightsComponentFeature = new ApplicationInsightsComponentFeature();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("FeatureName".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.featureName = reader.getString();
                    continue;
                }
                if ("MeterId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.meterId = reader.getString();
                    continue;
                }
                if ("MeterRateFrequency".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.meterRateFrequency = reader.getString();
                    continue;
                }
                if ("ResouceId".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.resouceId = reader.getString();
                    continue;
                }
                if ("IsHidden".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.isHidden = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("Capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedApplicationInsightsComponentFeature.capabilities = capabilities = reader.readArray(reader1 -> ApplicationInsightsComponentFeatureCapability.fromJson(reader1));
                    continue;
                }
                if ("Title".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.title = reader.getString();
                    continue;
                }
                if ("IsMainFeature".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.isMainFeature = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("SupportedAddonFeatures".equals(fieldName)) {
                    deserializedApplicationInsightsComponentFeature.supportedAddonFeatures = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInsightsComponentFeature;
        });
    }
}

