/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentInner;
import java.io.IOException;
import java.util.List;

public final class ApplicationInsightsComponentListResult
implements JsonSerializable<ApplicationInsightsComponentListResult> {
    private List<ApplicationInsightsComponentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsComponentListResult.class);

    public List<ApplicationInsightsComponentInner> value() {
        return this.value;
    }

    public ApplicationInsightsComponentListResult withValue(List<ApplicationInsightsComponentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ApplicationInsightsComponentListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ApplicationInsightsComponentListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationInsightsComponentListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationInsightsComponentListResult)jsonReader.readObject(reader -> {
            ApplicationInsightsComponentListResult deserializedApplicationInsightsComponentListResult = new ApplicationInsightsComponentListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApplicationInsightsComponentListResult.value = value = reader.readArray(reader1 -> ApplicationInsightsComponentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedApplicationInsightsComponentListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationInsightsComponentListResult;
        });
    }
}

