/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.ComponentPurgeBodyFilters;
import java.io.IOException;
import java.util.List;

public final class ComponentPurgeBody
implements JsonSerializable<ComponentPurgeBody> {
    private String table;
    private List<ComponentPurgeBodyFilters> filters;
    private static final ClientLogger LOGGER = new ClientLogger(ComponentPurgeBody.class);

    public String table() {
        return this.table;
    }

    public ComponentPurgeBody withTable(String table) {
        this.table = table;
        return this;
    }

    public List<ComponentPurgeBodyFilters> filters() {
        return this.filters;
    }

    public ComponentPurgeBody withFilters(List<ComponentPurgeBodyFilters> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.table() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property table in model ComponentPurgeBody"));
        }
        if (this.filters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filters in model ComponentPurgeBody"));
        }
        this.filters().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("table", this.table);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ComponentPurgeBody fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentPurgeBody)jsonReader.readObject(reader -> {
            ComponentPurgeBody deserializedComponentPurgeBody = new ComponentPurgeBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("table".equals(fieldName)) {
                    deserializedComponentPurgeBody.table = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedComponentPurgeBody.filters = filters = reader.readArray(reader1 -> ComponentPurgeBodyFilters.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedComponentPurgeBody;
        });
    }
}

