/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class InnerError
implements JsonSerializable<InnerError> {
    private String diagnosticcontext;
    private OffsetDateTime time;

    public String diagnosticcontext() {
        return this.diagnosticcontext;
    }

    public InnerError withDiagnosticcontext(String diagnosticcontext) {
        this.diagnosticcontext = diagnosticcontext;
        return this;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public InnerError withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diagnosticcontext", this.diagnosticcontext);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        return jsonWriter.writeEndObject();
    }

    public static InnerError fromJson(JsonReader jsonReader) throws IOException {
        return (InnerError)jsonReader.readObject(reader -> {
            InnerError deserializedInnerError = new InnerError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diagnosticcontext".equals(fieldName)) {
                    deserializedInnerError.diagnosticcontext = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedInnerError.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInnerError;
        });
    }
}

