/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbookManagedIdentity;
import java.io.IOException;
import java.util.Map;

public class MyWorkbookResource
extends Resource {
    private MyWorkbookManagedIdentity identity;
    private String id;
    private String name;
    private String type;
    private Map<String, String> etag;

    public MyWorkbookManagedIdentity identity() {
        return this.identity;
    }

    public MyWorkbookResource withIdentity(MyWorkbookManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String id() {
        return this.id;
    }

    public MyWorkbookResource withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MyWorkbookResource withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public MyWorkbookResource withType(String type) {
        this.type = type;
        return this;
    }

    public Map<String, String> etag() {
        return this.etag;
    }

    public MyWorkbookResource withEtag(Map<String, String> etag) {
        this.etag = etag;
        return this;
    }

    public MyWorkbookResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public MyWorkbookResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("etag", this.etag, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MyWorkbookResource fromJson(JsonReader jsonReader) throws IOException {
        return (MyWorkbookResource)((Object)jsonReader.readObject(reader -> {
            MyWorkbookResource deserializedMyWorkbookResource = new MyWorkbookResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedMyWorkbookResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedMyWorkbookResource.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedMyWorkbookResource.identity = MyWorkbookManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMyWorkbookResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMyWorkbookResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMyWorkbookResource.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    Map etag;
                    deserializedMyWorkbookResource.etag = etag = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMyWorkbookResource;
        }));
    }
}

