/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WebTestInner;
import java.io.IOException;
import java.util.List;

public final class WebTestListResult
implements JsonSerializable<WebTestListResult> {
    private List<WebTestInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WebTestListResult.class);

    public List<WebTestInner> value() {
        return this.value;
    }

    public WebTestListResult withValue(List<WebTestInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public WebTestListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WebTestListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static WebTestListResult fromJson(JsonReader jsonReader) throws IOException {
        return (WebTestListResult)jsonReader.readObject(reader -> {
            WebTestListResult deserializedWebTestListResult = new WebTestListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWebTestListResult.value = value = reader.readArray(reader1 -> WebTestInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWebTestListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebTestListResult;
        });
    }
}

