/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.HeaderField;
import java.io.IOException;
import java.util.List;

public final class WebTestPropertiesRequest
implements JsonSerializable<WebTestPropertiesRequest> {
    private String requestUrl;
    private List<HeaderField> headers;
    private String httpVerb;
    private String requestBody;
    private Boolean parseDependentRequests;
    private Boolean followRedirects;

    public String requestUrl() {
        return this.requestUrl;
    }

    public WebTestPropertiesRequest withRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    public List<HeaderField> headers() {
        return this.headers;
    }

    public WebTestPropertiesRequest withHeaders(List<HeaderField> headers) {
        this.headers = headers;
        return this;
    }

    public String httpVerb() {
        return this.httpVerb;
    }

    public WebTestPropertiesRequest withHttpVerb(String httpVerb) {
        this.httpVerb = httpVerb;
        return this;
    }

    public String requestBody() {
        return this.requestBody;
    }

    public WebTestPropertiesRequest withRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Boolean parseDependentRequests() {
        return this.parseDependentRequests;
    }

    public WebTestPropertiesRequest withParseDependentRequests(Boolean parseDependentRequests) {
        this.parseDependentRequests = parseDependentRequests;
        return this;
    }

    public Boolean followRedirects() {
        return this.followRedirects;
    }

    public WebTestPropertiesRequest withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("RequestUrl", this.requestUrl);
        jsonWriter.writeArrayField("Headers", this.headers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("HttpVerb", this.httpVerb);
        jsonWriter.writeStringField("RequestBody", this.requestBody);
        jsonWriter.writeBooleanField("ParseDependentRequests", this.parseDependentRequests);
        jsonWriter.writeBooleanField("FollowRedirects", this.followRedirects);
        return jsonWriter.writeEndObject();
    }

    public static WebTestPropertiesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (WebTestPropertiesRequest)jsonReader.readObject(reader -> {
            WebTestPropertiesRequest deserializedWebTestPropertiesRequest = new WebTestPropertiesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("RequestUrl".equals(fieldName)) {
                    deserializedWebTestPropertiesRequest.requestUrl = reader.getString();
                    continue;
                }
                if ("Headers".equals(fieldName)) {
                    List headers;
                    deserializedWebTestPropertiesRequest.headers = headers = reader.readArray(reader1 -> HeaderField.fromJson(reader1));
                    continue;
                }
                if ("HttpVerb".equals(fieldName)) {
                    deserializedWebTestPropertiesRequest.httpVerb = reader.getString();
                    continue;
                }
                if ("RequestBody".equals(fieldName)) {
                    deserializedWebTestPropertiesRequest.requestBody = reader.getString();
                    continue;
                }
                if ("ParseDependentRequests".equals(fieldName)) {
                    deserializedWebTestPropertiesRequest.parseDependentRequests = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("FollowRedirects".equals(fieldName)) {
                    deserializedWebTestPropertiesRequest.followRedirects = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebTestPropertiesRequest;
        });
    }
}

