/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesValidationRulesContentValidation;
import java.io.IOException;

public final class WebTestPropertiesValidationRules
implements JsonSerializable<WebTestPropertiesValidationRules> {
    private WebTestPropertiesValidationRulesContentValidation contentValidation;
    private Boolean sslCheck;
    private Integer sslCertRemainingLifetimeCheck;
    private Integer expectedHttpStatusCode;
    private Boolean ignoreHttpStatusCode;

    public WebTestPropertiesValidationRulesContentValidation contentValidation() {
        return this.contentValidation;
    }

    public WebTestPropertiesValidationRules withContentValidation(WebTestPropertiesValidationRulesContentValidation contentValidation) {
        this.contentValidation = contentValidation;
        return this;
    }

    public Boolean sslCheck() {
        return this.sslCheck;
    }

    public WebTestPropertiesValidationRules withSslCheck(Boolean sslCheck) {
        this.sslCheck = sslCheck;
        return this;
    }

    public Integer sslCertRemainingLifetimeCheck() {
        return this.sslCertRemainingLifetimeCheck;
    }

    public WebTestPropertiesValidationRules withSslCertRemainingLifetimeCheck(Integer sslCertRemainingLifetimeCheck) {
        this.sslCertRemainingLifetimeCheck = sslCertRemainingLifetimeCheck;
        return this;
    }

    public Integer expectedHttpStatusCode() {
        return this.expectedHttpStatusCode;
    }

    public WebTestPropertiesValidationRules withExpectedHttpStatusCode(Integer expectedHttpStatusCode) {
        this.expectedHttpStatusCode = expectedHttpStatusCode;
        return this;
    }

    public Boolean ignoreHttpStatusCode() {
        return this.ignoreHttpStatusCode;
    }

    public WebTestPropertiesValidationRules withIgnoreHttpStatusCode(Boolean ignoreHttpStatusCode) {
        this.ignoreHttpStatusCode = ignoreHttpStatusCode;
        return this;
    }

    public void validate() {
        if (this.contentValidation() != null) {
            this.contentValidation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("ContentValidation", (JsonSerializable)this.contentValidation);
        jsonWriter.writeBooleanField("SSLCheck", this.sslCheck);
        jsonWriter.writeNumberField("SSLCertRemainingLifetimeCheck", (Number)this.sslCertRemainingLifetimeCheck);
        jsonWriter.writeNumberField("ExpectedHttpStatusCode", (Number)this.expectedHttpStatusCode);
        jsonWriter.writeBooleanField("IgnoreHttpStatusCode", this.ignoreHttpStatusCode);
        return jsonWriter.writeEndObject();
    }

    public static WebTestPropertiesValidationRules fromJson(JsonReader jsonReader) throws IOException {
        return (WebTestPropertiesValidationRules)jsonReader.readObject(reader -> {
            WebTestPropertiesValidationRules deserializedWebTestPropertiesValidationRules = new WebTestPropertiesValidationRules();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ContentValidation".equals(fieldName)) {
                    deserializedWebTestPropertiesValidationRules.contentValidation = WebTestPropertiesValidationRulesContentValidation.fromJson(reader);
                    continue;
                }
                if ("SSLCheck".equals(fieldName)) {
                    deserializedWebTestPropertiesValidationRules.sslCheck = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("SSLCertRemainingLifetimeCheck".equals(fieldName)) {
                    deserializedWebTestPropertiesValidationRules.sslCertRemainingLifetimeCheck = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ExpectedHttpStatusCode".equals(fieldName)) {
                    deserializedWebTestPropertiesValidationRules.expectedHttpStatusCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("IgnoreHttpStatusCode".equals(fieldName)) {
                    deserializedWebTestPropertiesValidationRules.ignoreHttpStatusCode = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebTestPropertiesValidationRules;
        });
    }
}

