/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.management.exception.AdditionalInfo;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.InnerError;
import java.io.IOException;
import java.util.List;

public final class WorkItemConfigurationError
extends ManagementError {
    private InnerError innererror;
    private List<AdditionalInfo> additionalInfo;
    private List<ManagementError> details;
    private String target;
    private String message;
    private String code;

    public InnerError getInnererror() {
        return this.innererror;
    }

    public List<AdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public List<ManagementError> getDetails() {
        return this.details;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public void validate() {
        if (this.getInnererror() != null) {
            this.getInnererror().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static WorkItemConfigurationError fromJson(JsonReader jsonReader) throws IOException {
        return (WorkItemConfigurationError)((Object)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return WorkItemConfigurationError.readManagementError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return WorkItemConfigurationError.readManagementError(bufferedReader.reset());
        }));
    }

    private static WorkItemConfigurationError readManagementError(JsonReader jsonReader) throws IOException {
        return (WorkItemConfigurationError)((Object)jsonReader.readObject(reader -> {
            WorkItemConfigurationError deserializedWorkItemConfigurationError = new WorkItemConfigurationError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedWorkItemConfigurationError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedWorkItemConfigurationError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedWorkItemConfigurationError.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedWorkItemConfigurationError.details = details = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedWorkItemConfigurationError.additionalInfo = additionalInfo = reader.readArray(reader1 -> AdditionalInfo.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    deserializedWorkItemConfigurationError.innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkItemConfigurationError;
        }));
    }
}

