/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class WorkItemCreateConfiguration
implements JsonSerializable<WorkItemCreateConfiguration> {
    private String connectorId;
    private String connectorDataConfiguration;
    private Boolean validateOnly;
    private Map<String, String> workItemProperties;

    public String connectorId() {
        return this.connectorId;
    }

    public WorkItemCreateConfiguration withConnectorId(String connectorId) {
        this.connectorId = connectorId;
        return this;
    }

    public String connectorDataConfiguration() {
        return this.connectorDataConfiguration;
    }

    public WorkItemCreateConfiguration withConnectorDataConfiguration(String connectorDataConfiguration) {
        this.connectorDataConfiguration = connectorDataConfiguration;
        return this;
    }

    public Boolean validateOnly() {
        return this.validateOnly;
    }

    public WorkItemCreateConfiguration withValidateOnly(Boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
    }

    public Map<String, String> workItemProperties() {
        return this.workItemProperties;
    }

    public WorkItemCreateConfiguration withWorkItemProperties(Map<String, String> workItemProperties) {
        this.workItemProperties = workItemProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ConnectorId", this.connectorId);
        jsonWriter.writeStringField("ConnectorDataConfiguration", this.connectorDataConfiguration);
        jsonWriter.writeBooleanField("ValidateOnly", this.validateOnly);
        jsonWriter.writeMapField("WorkItemProperties", this.workItemProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WorkItemCreateConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (WorkItemCreateConfiguration)jsonReader.readObject(reader -> {
            WorkItemCreateConfiguration deserializedWorkItemCreateConfiguration = new WorkItemCreateConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ConnectorId".equals(fieldName)) {
                    deserializedWorkItemCreateConfiguration.connectorId = reader.getString();
                    continue;
                }
                if ("ConnectorDataConfiguration".equals(fieldName)) {
                    deserializedWorkItemCreateConfiguration.connectorDataConfiguration = reader.getString();
                    continue;
                }
                if ("ValidateOnly".equals(fieldName)) {
                    deserializedWorkItemCreateConfiguration.validateOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("WorkItemProperties".equals(fieldName)) {
                    Map workItemProperties;
                    deserializedWorkItemCreateConfiguration.workItemProperties = workItemProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkItemCreateConfiguration;
        });
    }
}

