/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResourceIdentity;
import com.azure.resourcemanager.applicationinsights.models.WorkbookSharedTypeKind;
import java.io.IOException;
import java.util.Map;

public class WorkbookResource
extends Resource {
    private WorkbookResourceIdentity identity;
    private WorkbookSharedTypeKind kind;
    private String etag;
    private String type;
    private String name;
    private String id;

    public WorkbookResourceIdentity identity() {
        return this.identity;
    }

    public WorkbookResource withIdentity(WorkbookResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public WorkbookSharedTypeKind kind() {
        return this.kind;
    }

    public WorkbookResource withKind(WorkbookSharedTypeKind kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public WorkbookResource withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public WorkbookResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WorkbookResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookResource fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookResource)((Object)jsonReader.readObject(reader -> {
            WorkbookResource deserializedWorkbookResource = new WorkbookResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkbookResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkbookResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkbookResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkbookResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkbookResource.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkbookResource.identity = WorkbookResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWorkbookResource.kind = WorkbookSharedTypeKind.fromString(reader.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWorkbookResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookResource;
        }));
    }
}

