/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.models.ManagedServiceIdentity;
import com.azure.resourcemanager.applicationinsights.models.ManagedServiceIdentityType;
import com.azure.resourcemanager.applicationinsights.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class WorkbookResourceIdentity
extends ManagedServiceIdentity {
    private UUID tenantId;
    private UUID principalId;
    private static final ClientLogger LOGGER = new ClientLogger(WorkbookResourceIdentity.class);

    @Override
    public UUID tenantId() {
        return this.tenantId;
    }

    @Override
    public UUID principalId() {
        return this.principalId;
    }

    @Override
    public WorkbookResourceIdentity withType(ManagedServiceIdentityType type) {
        super.withType(type);
        return this;
    }

    @Override
    public WorkbookResourceIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        super.withUserAssignedIdentities(userAssignedIdentities);
        return this;
    }

    @Override
    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model WorkbookResourceIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkbookResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookResourceIdentity)jsonReader.readObject(reader -> {
            WorkbookResourceIdentity deserializedWorkbookResourceIdentity = new WorkbookResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedWorkbookResourceIdentity.withType(ManagedServiceIdentityType.fromString(reader.getString()));
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedWorkbookResourceIdentity.principalId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedWorkbookResourceIdentity.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    deserializedWorkbookResourceIdentity.withUserAssignedIdentities(userAssignedIdentities);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookResourceIdentity;
        });
    }
}

