/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookTemplateProperties;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateGallery;
import com.azure.resourcemanager.applicationinsights.models.WorkbookTemplateLocalizedGallery;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkbookTemplateUpdateParameters
implements JsonSerializable<WorkbookTemplateUpdateParameters> {
    private Map<String, String> tags;
    private WorkbookTemplateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public WorkbookTemplateUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private WorkbookTemplateProperties innerProperties() {
        return this.innerProperties;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    public WorkbookTemplateUpdateParameters withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    public WorkbookTemplateUpdateParameters withAuthor(String author) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withAuthor(author);
        return this;
    }

    public Object templateData() {
        return this.innerProperties() == null ? null : this.innerProperties().templateData();
    }

    public WorkbookTemplateUpdateParameters withTemplateData(Object templateData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withTemplateData(templateData);
        return this;
    }

    public List<WorkbookTemplateGallery> galleries() {
        return this.innerProperties() == null ? null : this.innerProperties().galleries();
    }

    public WorkbookTemplateUpdateParameters withGalleries(List<WorkbookTemplateGallery> galleries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withGalleries(galleries);
        return this;
    }

    public Map<String, List<WorkbookTemplateLocalizedGallery>> localized() {
        return this.innerProperties() == null ? null : this.innerProperties().localized();
    }

    public WorkbookTemplateUpdateParameters withLocalized(Map<String, List<WorkbookTemplateLocalizedGallery>> localized) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookTemplateProperties();
        }
        this.innerProperties().withLocalized(localized);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookTemplateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookTemplateUpdateParameters)jsonReader.readObject(reader -> {
            WorkbookTemplateUpdateParameters deserializedWorkbookTemplateUpdateParameters = new WorkbookTemplateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedWorkbookTemplateUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkbookTemplateUpdateParameters.innerProperties = WorkbookTemplateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookTemplateUpdateParameters;
        });
    }
}

