/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.applicationinsights.fluent.models.WorkbookPropertiesUpdateParameters;
import com.azure.resourcemanager.applicationinsights.models.WorkbookUpdateSharedTypeKind;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkbookUpdateParameters
implements JsonSerializable<WorkbookUpdateParameters> {
    private WorkbookUpdateSharedTypeKind kind;
    private Map<String, String> tags;
    private WorkbookPropertiesUpdateParameters innerProperties;

    public WorkbookUpdateSharedTypeKind kind() {
        return this.kind;
    }

    public WorkbookUpdateParameters withKind(WorkbookUpdateSharedTypeKind kind) {
        this.kind = kind;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public WorkbookUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private WorkbookPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public WorkbookUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String serializedData() {
        return this.innerProperties() == null ? null : this.innerProperties().serializedData();
    }

    public WorkbookUpdateParameters withSerializedData(String serializedData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withSerializedData(serializedData);
        return this;
    }

    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    public WorkbookUpdateParameters withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    public List<String> tagsPropertiesTags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public WorkbookUpdateParameters withTagsPropertiesTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public WorkbookUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String revision() {
        return this.innerProperties() == null ? null : this.innerProperties().revision();
    }

    public WorkbookUpdateParameters withRevision(String revision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookPropertiesUpdateParameters();
        }
        this.innerProperties().withRevision(revision);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkbookUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WorkbookUpdateParameters)jsonReader.readObject(reader -> {
            WorkbookUpdateParameters deserializedWorkbookUpdateParameters = new WorkbookUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedWorkbookUpdateParameters.kind = WorkbookUpdateSharedTypeKind.fromString(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedWorkbookUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkbookUpdateParameters.innerProperties = WorkbookPropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkbookUpdateParameters;
        });
    }
}

