/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.ServicesClient;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.NameAvailability;
import com.azure.resourcemanager.appplatform.models.NameAvailabilityParameters;
import com.azure.resourcemanager.appplatform.models.ResourceSku;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServices;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import reactor.core.publisher.Mono;

public class SpringServicesImpl
extends GroupableResourcesImpl<SpringService, SpringServiceImpl, ServiceResourceInner, ServicesClient, AppPlatformManager>
implements SpringServices {
    private static final String SPRING_TYPE = "Microsoft.AppPlatform/Spring";

    public SpringServicesImpl(AppPlatformManager manager) {
        super((Object)((AppPlatformManagementClient)manager.serviceClient()).getServices(), (Manager)manager);
    }

    protected Mono<ServiceResourceInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ServicesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ServicesClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    protected SpringServiceImpl wrapModel(String name) {
        return new SpringServiceImpl(name, new ServiceResourceInner(), (AppPlatformManager)this.manager());
    }

    protected SpringServiceImpl wrapModel(ServiceResourceInner inner) {
        return inner == null ? null : new SpringServiceImpl(inner.name(), inner, (AppPlatformManager)this.manager());
    }

    @Override
    public NameAvailability checkNameAvailability(String name, Region region) {
        return (NameAvailability)this.checkNameAvailabilityAsync(name, region).block();
    }

    @Override
    public Mono<NameAvailability> checkNameAvailabilityAsync(String name, Region region) {
        return ((ServicesClient)this.inner()).checkNameAvailabilityAsync(region.toString(), new NameAvailabilityParameters().withName(name).withType(SPRING_TYPE));
    }

    @Override
    public PagedIterable<ResourceSku> listSkus() {
        return new PagedIterable(this.listSkusAsync());
    }

    @Override
    public PagedFlux<ResourceSku> listSkusAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getSkus().listAsync();
    }

    public PagedIterable<SpringService> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<SpringService> listByResourceGroupAsync(String resourceGroupName) {
        return ((ServicesClient)this.inner()).listByResourceGroupAsync(resourceGroupName).mapPage(this::wrapModel);
    }

    public SpringServiceImpl define(String name) {
        return this.wrapModel(name);
    }

    public PagedIterable<SpringService> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SpringService> listAsync() {
        return ((ServicesClient)this.inner()).listAsync().mapPage(this::wrapModel);
    }
}

