/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.DeploymentResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.LogFileUrlResponseInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceProperties;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.ResourceUploadDefinition;
import com.azure.resourcemanager.appplatform.models.RuntimeVersion;
import com.azure.resourcemanager.appplatform.models.Sku;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringAppDeployment;
import com.azure.resourcemanager.appplatform.models.UserSourceInfo;
import com.azure.resourcemanager.appplatform.models.UserSourceType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import reactor.core.publisher.Mono;

public class SpringAppDeploymentImpl
extends ExternalChildResourceImpl<SpringAppDeployment, DeploymentResourceInner, SpringAppImpl, SpringApp>
implements SpringAppDeployment,
SpringAppDeployment.Definition<SpringAppImpl, SpringAppDeploymentImpl>,
SpringAppDeployment.Update {
    SpringAppDeploymentImpl(String name, SpringAppImpl parent, DeploymentResourceInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    @Override
    public String appName() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().appName();
    }

    @Override
    public DeploymentSettings settings() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings();
    }

    @Override
    public DeploymentResourceStatus status() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().status();
    }

    @Override
    public boolean isActive() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return false;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().active();
    }

    @Override
    public OffsetDateTime createdTime() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().createdTime();
    }

    @Override
    public List<DeploymentInstance> instances() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentResourceInner)((Object)this.innerModel())).properties().instances();
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().startAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().stopAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().restartAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    @Override
    public String getLogFileUrl() {
        return (String)this.getLogFileUrlAsync().block();
    }

    @Override
    public Mono<String> getLogFileUrlAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().getLogFileUrlAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name()).map(LogFileUrlResponseInner::url);
    }

    private void ensureDeploySettings() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).withProperties(new DeploymentResourceProperties());
        }
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).properties().withDeploymentSettings(new DeploymentSettings());
        }
    }

    private void ensureSource() {
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).withProperties(new DeploymentResourceProperties());
        }
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties().source() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).properties().withSource(new UserSourceInfo());
        }
    }

    private ShareFileAsyncClient createShareFileAsyncClient(ResourceUploadDefinition option) {
        return new ShareFileClientBuilder().endpoint(option.uploadUrl()).httpClient(this.manager().httpPipeline().getHttpClient()).buildFileAsyncClient();
    }

    private Mono<Void> uploadToStorage(File source, ResourceUploadDefinition option) {
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withRelativePath(option.relativePath());
        try {
            ShareFileAsyncClient shareFileAsyncClient = this.createShareFileAsyncClient(option);
            return shareFileAsyncClient.create(source.length()).flatMap(fileInfo -> shareFileAsyncClient.uploadFromFile(source.getAbsolutePath())).then(Mono.empty());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public SpringAppDeploymentImpl withJarFile(File jar) {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withType(UserSourceType.JAR);
        this.addDependency(context -> ((SpringAppImpl)this.parent()).getResourceUploadUrlAsync().flatMap(option -> this.uploadToStorage(jar, (ResourceUploadDefinition)option).then(context.voidMono())));
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withExistingSource(UserSourceType type, String relativePath) {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withType(type);
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withRelativePath(relativePath);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withSourceCodeTarGzFile(File sourceCodeTarGz) {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withType(UserSourceType.SOURCE);
        this.addDependency(context -> ((SpringAppImpl)this.parent()).getResourceUploadUrlAsync().flatMap(option -> this.uploadToStorage(sourceCodeTarGz, (ResourceUploadDefinition)option).then(context.voidMono())));
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withTargetModule(String moduleName) {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withArtifactSelector(moduleName);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withSingleModule() {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withArtifactSelector(null);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withInstance(int count) {
        if (((DeploymentResourceInner)((Object)this.innerModel())).sku() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).withSku(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).sku());
        }
        if (((DeploymentResourceInner)((Object)this.innerModel())).sku() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).withSku(new Sku().withName("B0"));
        }
        ((DeploymentResourceInner)((Object)this.innerModel())).sku().withCapacity(count);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withCpu(int cpuCount) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().withCpu(cpuCount);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withMemory(int sizeInGB) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().withMemoryInGB(sizeInGB);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withRuntime(RuntimeVersion version) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().withRuntimeVersion(version);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withJvmOptions(String jvmOptions) {
        this.ensureDeploySettings();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().withJvmOptions(jvmOptions);
        return this;
    }

    private void ensureEnvironments() {
        this.ensureDeploySettings();
        if (((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().environmentVariables() == null) {
            ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().withEnvironmentVariables(new HashMap<String, String>());
        }
    }

    @Override
    public SpringAppDeploymentImpl withEnvironment(String key, String value) {
        this.ensureEnvironments();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().environmentVariables().put(key, value);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withoutEnvironment(String key) {
        this.ensureEnvironments();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().deploymentSettings().environmentVariables().remove(key);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withVersionName(String versionName) {
        this.ensureSource();
        ((DeploymentResourceInner)((Object)this.innerModel())).properties().source().withVersion(versionName);
        return this;
    }

    @Override
    public SpringAppDeploymentImpl withActivation() {
        this.addPostRunDependent(context -> ((SpringAppImpl)this.parent()).update().withActiveDeployment(this.name()).applyAsync().map(app -> app));
        return this;
    }

    public Mono<SpringAppDeployment> createResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().createOrUpdateAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name(), (DeploymentResourceInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<SpringAppDeployment> updateResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().updateAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name(), (DeploymentResourceInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().deleteAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    protected Mono<DeploymentResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getDeployments().getAsync(((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).resourceGroupName(), ((SpringServiceImpl)((SpringAppImpl)this.parent()).parent()).name(), ((SpringAppImpl)this.parent()).name(), this.name());
    }

    public String id() {
        return ((DeploymentResourceInner)((Object)this.innerModel())).id();
    }

    public SpringAppDeploymentImpl update() {
        this.prepareUpdate();
        return this;
    }

    private AppPlatformManager manager() {
        return ((SpringAppImpl)this.parent()).manager();
    }

    public SpringAppImpl attach() {
        return ((SpringAppImpl)this.parent()).addActiveDeployment(this);
    }
}

