/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigServerResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.MonitoringSettingResourceInner;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppsImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceCertificatesImpl;
import com.azure.resourcemanager.appplatform.models.CertificateProperties;
import com.azure.resourcemanager.appplatform.models.ConfigServerGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import com.azure.resourcemanager.appplatform.models.ConfigServerSettings;
import com.azure.resourcemanager.appplatform.models.MonitoringSettingProperties;
import com.azure.resourcemanager.appplatform.models.Sku;
import com.azure.resourcemanager.appplatform.models.SkuName;
import com.azure.resourcemanager.appplatform.models.SpringApps;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServiceCertificates;
import com.azure.resourcemanager.appplatform.models.TestKeyType;
import com.azure.resourcemanager.appplatform.models.TestKeys;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import reactor.core.publisher.Mono;

public class SpringServiceImpl
extends GroupableResourceImpl<SpringService, ServiceResourceInner, SpringServiceImpl, AppPlatformManager>
implements SpringService,
SpringService.Definition,
SpringService.Update {
    private final SpringServiceCertificatesImpl certificates = new SpringServiceCertificatesImpl(this);
    private final SpringAppsImpl apps = new SpringAppsImpl(this);
    private FunctionalTaskItem configServerTask = null;
    private FunctionalTaskItem monitoringSettingTask = null;
    private boolean needUpdate = false;

    SpringServiceImpl(String name, ServiceResourceInner innerObject, AppPlatformManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    @Override
    public Sku sku() {
        return ((ServiceResourceInner)((Object)this.innerModel())).sku();
    }

    @Override
    public SpringApps apps() {
        return this.apps;
    }

    @Override
    public SpringServiceCertificates certificates() {
        return this.certificates;
    }

    @Override
    public MonitoringSettingProperties getMonitoringSetting() {
        return (MonitoringSettingProperties)this.getMonitoringSettingAsync().block();
    }

    @Override
    public Mono<MonitoringSettingProperties> getMonitoringSettingAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().getAsync(this.resourceGroupName(), this.name()).map(MonitoringSettingResourceInner::properties);
    }

    @Override
    public ConfigServerProperties getServerProperties() {
        return (ConfigServerProperties)this.getServerPropertiesAsync().block();
    }

    @Override
    public Mono<ConfigServerProperties> getServerPropertiesAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().getAsync(this.resourceGroupName(), this.name()).map(ConfigServerResourceInner::properties);
    }

    @Override
    public TestKeys listTestKeys() {
        return (TestKeys)this.listTestKeysAsync().block();
    }

    @Override
    public Mono<TestKeys> listTestKeysAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().listTestKeysAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TestKeys regenerateTestKeys(TestKeyType keyType) {
        return (TestKeys)this.regenerateTestKeysAsync(keyType).block();
    }

    @Override
    public Mono<TestKeys> regenerateTestKeysAsync(TestKeyType keyType) {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().regenerateTestKeyAsync(this.resourceGroupName(), this.name(), keyType);
    }

    @Override
    public void disableTestEndpoint() {
        this.disableTestEndpointAsync().block();
    }

    @Override
    public Mono<Void> disableTestEndpointAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().disableTestEndpointAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public TestKeys enableTestEndpoint() {
        return (TestKeys)this.enableTestEndpointAsync().block();
    }

    @Override
    public Mono<TestKeys> enableTestEndpointAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().enableTestEndpointAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public SpringServiceImpl withSku(String skuName) {
        return this.withSku(new Sku().withName(skuName));
    }

    @Override
    public SpringServiceImpl withSku(SkuName skuName) {
        return this.withSku(skuName.toString());
    }

    @Override
    public SpringServiceImpl withSku(String skuName, int capacity) {
        return this.withSku(new Sku().withName(skuName).withCapacity(capacity));
    }

    @Override
    public SpringServiceImpl withSku(Sku sku) {
        this.needUpdate = true;
        ((ServiceResourceInner)((Object)this.innerModel())).withSku(sku);
        return this;
    }

    @Override
    public SpringServiceImpl withTracing(String appInsightInstrumentationKey) {
        this.monitoringSettingTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().updatePatchAsync(this.resourceGroupName(), this.name(), new MonitoringSettingProperties().withAppInsightsInstrumentationKey(appInsightInstrumentationKey).withTraceEnabled(true)).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withoutTracing() {
        this.monitoringSettingTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getMonitoringSettings().updatePatchAsync(this.resourceGroupName(), this.name(), new MonitoringSettingProperties().withTraceEnabled(false)).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitUri(String uri) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(new ConfigServerGitProperty().withUri(uri)))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitUriAndCredential(String uri, String username, String password) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(new ConfigServerGitProperty().withUri(uri).withUsername(username).withPassword(password)))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withGitConfig(ConfigServerGitProperty gitConfig) {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerProperties().withConfigServer(new ConfigServerSettings().withGitProperty(gitConfig))).then(context.voidMono());
        return this;
    }

    @Override
    public SpringServiceImpl withoutGitConfig() {
        this.configServerTask = context -> ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getConfigServers().updatePatchAsync(this.resourceGroupName(), this.name(), new ConfigServerProperties()).then(context.voidMono());
        return this;
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.configServerTask != null) {
            this.addPostRunDependent(this.configServerTask);
        }
        if (this.monitoringSettingTask != null) {
            this.addPostRunDependent(this.monitoringSettingTask);
        }
        this.configServerTask = null;
        this.monitoringSettingTask = null;
    }

    public Mono<SpringService> createResourceAsync() {
        Mono<ServiceResourceInner> createOrUpdate;
        if (this.isInCreateMode()) {
            createOrUpdate = ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServiceResourceInner)((Object)this.innerModel()));
        } else if (this.needUpdate) {
            this.needUpdate = false;
            createOrUpdate = ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().updateAsync(this.resourceGroupName(), this.name(), (ServiceResourceInner)((Object)this.innerModel()));
        } else {
            return Mono.just((Object)this);
        }
        return createOrUpdate.map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    protected Mono<ServiceResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)((AppPlatformManager)this.manager()).serviceClient()).getServices().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public SpringServiceImpl withCertificate(String name, String keyVaultUri, String certNameInKeyVault) {
        this.certificates.prepareCreateOrUpdate(name, new CertificateProperties().withVaultUri(keyVaultUri).withKeyVaultCertName(certNameInKeyVault));
        return this;
    }

    @Override
    public SpringServiceImpl withCertificate(String name, String keyVaultUri, String certNameInKeyVault, String certVersion) {
        this.certificates.prepareCreateOrUpdate(name, new CertificateProperties().withVaultUri(keyVaultUri).withKeyVaultCertName(certNameInKeyVault).withCertVersion(certVersion));
        return this;
    }

    @Override
    public SpringServiceImpl withoutCertificate(String name) {
        this.certificates.prepareDelete(name);
        return this;
    }
}

