/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Utils {
    private static final BigDecimal D_1000 = BigDecimal.valueOf(1000L);
    private static final BigDecimal D_1024 = BigDecimal.valueOf(1024L);

    Utils() {
    }

    public static Double fromCpuString(String cpu) {
        if (cpu == null) {
            return null;
        }
        CpuMatcher matcher = CpuMatcher.create(cpu);
        if (matcher.noMatch()) {
            throw new IllegalArgumentException(String.format("Illegal cpu format : %s", cpu));
        }
        if (matcher.matchFraction()) {
            return BigDecimal.valueOf(Long.parseLong(matcher.getFraction())).divide(D_1000, 1, RoundingMode.CEILING).doubleValue();
        }
        return Double.valueOf(cpu);
    }

    public static Double fromMemoryString(String memory) {
        if (memory == null) {
            return null;
        }
        MemoryMatcher matcher = MemoryMatcher.create(memory);
        if (matcher.noMatch()) {
            throw new IllegalArgumentException(String.format("Illegal memory format : %s", memory));
        }
        if (matcher.matchGB()) {
            return Double.valueOf(matcher.getGBString());
        }
        return BigDecimal.valueOf(Long.parseLong(matcher.getMBString())).divide(D_1024, 1, RoundingMode.CEILING).doubleValue();
    }

    public static String toCpuString(double cpuCount) {
        BigDecimal cpuDecimal = BigDecimal.valueOf(cpuCount);
        if (Utils.isInteger(cpuCount)) {
            return String.valueOf(cpuDecimal.intValue());
        }
        return String.format("%dm", cpuDecimal.multiply(D_1000).intValue());
    }

    public static String toMemoryString(double sizeInGB) {
        BigDecimal memoryDecimal = BigDecimal.valueOf(sizeInGB);
        if (Utils.isInteger(sizeInGB)) {
            return String.format("%dGi", memoryDecimal.intValue());
        }
        return String.format("%dMi", memoryDecimal.multiply(D_1024).intValue());
    }

    private static boolean isInteger(double sizeInGB) {
        return sizeInGB % 1.0 == 0.0;
    }

    private static class MemoryMatcher {
        static final Pattern MEMORY_GB = Pattern.compile("^([0-9]+)Gi");
        static final Pattern MEMORY_MB = Pattern.compile("^([0-9]+)Mi");
        Matcher gbMatcher;
        Matcher mbMatcher;

        MemoryMatcher(Matcher gbMatcher, Matcher mbMatcher) {
            this.gbMatcher = gbMatcher;
            this.mbMatcher = mbMatcher;
        }

        static MemoryMatcher create(String memory) {
            Matcher gbMatcher = MEMORY_GB.matcher(memory);
            Matcher mbMatcher = MEMORY_MB.matcher(memory);
            return new MemoryMatcher(gbMatcher.matches() ? gbMatcher : null, mbMatcher.matches() ? mbMatcher : null);
        }

        boolean noMatch() {
            return this.gbMatcher == null && this.mbMatcher == null;
        }

        boolean matchGB() {
            return this.gbMatcher != null;
        }

        String getGBString() {
            return this.gbMatcher.group(1);
        }

        String getMBString() {
            return this.mbMatcher.group(1);
        }
    }

    private static class CpuMatcher {
        static final Pattern CPU_INTEGER = Pattern.compile("^[0-9]+$");
        static final Pattern CPU_FRACTION = Pattern.compile("^([0-9]+)m$");
        Matcher integerMatcher;
        Matcher fractionMatcher;

        CpuMatcher(Matcher integerMatcher, Matcher fractionMatcher) {
            this.integerMatcher = integerMatcher;
            this.fractionMatcher = fractionMatcher;
        }

        static CpuMatcher create(String cpu) {
            Matcher integerMatcher = CPU_INTEGER.matcher(cpu);
            Matcher fractionMatcher = CPU_FRACTION.matcher(cpu);
            return new CpuMatcher(integerMatcher.matches() ? integerMatcher : null, fractionMatcher.matches() ? fractionMatcher : null);
        }

        boolean noMatch() {
            return this.integerMatcher == null && this.fractionMatcher == null;
        }

        boolean matchFraction() {
            return this.fractionMatcher != null;
        }

        String getFraction() {
            return this.fractionMatcher.group(1);
        }
    }
}

