/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.DeploymentInstance;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceProvisioningState;
import com.azure.resourcemanager.appplatform.models.DeploymentResourceStatus;
import com.azure.resourcemanager.appplatform.models.DeploymentSettings;
import com.azure.resourcemanager.appplatform.models.UserSourceInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DeploymentResourceProperties {
    @JsonProperty(value="source")
    private UserSourceInfo source;
    @JsonProperty(value="deploymentSettings")
    private DeploymentSettings deploymentSettings;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentResourceProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentResourceStatus status;
    @JsonProperty(value="active")
    private Boolean active;
    @JsonProperty(value="instances", access=JsonProperty.Access.WRITE_ONLY)
    private List<DeploymentInstance> instances;

    public UserSourceInfo source() {
        return this.source;
    }

    public DeploymentResourceProperties withSource(UserSourceInfo source) {
        this.source = source;
        return this;
    }

    public DeploymentSettings deploymentSettings() {
        return this.deploymentSettings;
    }

    public DeploymentResourceProperties withDeploymentSettings(DeploymentSettings deploymentSettings) {
        this.deploymentSettings = deploymentSettings;
        return this;
    }

    public DeploymentResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentResourceStatus status() {
        return this.status;
    }

    public Boolean active() {
        return this.active;
    }

    public DeploymentResourceProperties withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public List<DeploymentInstance> instances() {
        return this.instances;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.deploymentSettings() != null) {
            this.deploymentSettings().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
    }
}

