// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for BuildResultProvisioningState. */
public final class BuildResultProvisioningState extends ExpandableStringEnum<BuildResultProvisioningState> {
    /** Static value Queuing for BuildResultProvisioningState. */
    public static final BuildResultProvisioningState QUEUING = fromString("Queuing");

    /** Static value Building for BuildResultProvisioningState. */
    public static final BuildResultProvisioningState BUILDING = fromString("Building");

    /** Static value Succeeded for BuildResultProvisioningState. */
    public static final BuildResultProvisioningState SUCCEEDED = fromString("Succeeded");

    /** Static value Failed for BuildResultProvisioningState. */
    public static final BuildResultProvisioningState FAILED = fromString("Failed");

    /** Static value Deleting for BuildResultProvisioningState. */
    public static final BuildResultProvisioningState DELETING = fromString("Deleting");

    /**
     * Creates or finds a BuildResultProvisioningState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BuildResultProvisioningState.
     */
    @JsonCreator
    public static BuildResultProvisioningState fromString(String name) {
        return fromString(name, BuildResultProvisioningState.class);
    }

    /**
     * Gets known BuildResultProvisioningState values.
     *
     * @return known BuildResultProvisioningState values.
     */
    public static Collection<BuildResultProvisioningState> values() {
        return values(BuildResultProvisioningState.class);
    }
}
