// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Application Configuration Service properties payload. */
@Fluent
public final class ConfigurationServiceProperties {
    /*
     * State of the Application Configuration Service.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ConfigurationServiceProvisioningState provisioningState;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    @JsonProperty(value = "resourceRequests", access = JsonProperty.Access.WRITE_ONLY)
    private ConfigurationServiceResourceRequests resourceRequests;

    /*
     * Collection of instances belong to Application Configuration Service.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<ConfigurationServiceInstance> instances;

    /*
     * The settings of Application Configuration Service.
     */
    @JsonProperty(value = "settings")
    private ConfigurationServiceSettings settings;

    /**
     * Get the provisioningState property: State of the Application Configuration Service.
     *
     * @return the provisioningState value.
     */
    public ConfigurationServiceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     *
     * @return the resourceRequests value.
     */
    public ConfigurationServiceResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to Application Configuration Service.
     *
     * @return the instances value.
     */
    public List<ConfigurationServiceInstance> instances() {
        return this.instances;
    }

    /**
     * Get the settings property: The settings of Application Configuration Service.
     *
     * @return the settings value.
     */
    public ConfigurationServiceSettings settings() {
        return this.settings;
    }

    /**
     * Set the settings property: The settings of Application Configuration Service.
     *
     * @param settings the settings value to set.
     * @return the ConfigurationServiceProperties object itself.
     */
    public ConfigurationServiceProperties withSettings(ConfigurationServiceSettings settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
        if (settings() != null) {
            settings().validate();
        }
    }
}
