// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** Properties of certificate imported from key vault. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("KeyVaultCertificate")
@Fluent
public final class KeyVaultCertificateProperties extends CertificateProperties {
    /*
     * The vault uri of user key vault.
     */
    @JsonProperty(value = "vaultUri", required = true)
    private String vaultUri;

    /*
     * The certificate name of key vault.
     */
    @JsonProperty(value = "keyVaultCertName", required = true)
    private String keyVaultCertName;

    /*
     * The certificate version of key vault.
     */
    @JsonProperty(value = "certVersion")
    private String certVersion;

    /*
     * Optional. If set to true, it will not import private key from key vault.
     */
    @JsonProperty(value = "excludePrivateKey")
    private Boolean excludePrivateKey;

    /**
     * Get the vaultUri property: The vault uri of user key vault.
     *
     * @return the vaultUri value.
     */
    public String vaultUri() {
        return this.vaultUri;
    }

    /**
     * Set the vaultUri property: The vault uri of user key vault.
     *
     * @param vaultUri the vaultUri value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    /**
     * Get the keyVaultCertName property: The certificate name of key vault.
     *
     * @return the keyVaultCertName value.
     */
    public String keyVaultCertName() {
        return this.keyVaultCertName;
    }

    /**
     * Set the keyVaultCertName property: The certificate name of key vault.
     *
     * @param keyVaultCertName the keyVaultCertName value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withKeyVaultCertName(String keyVaultCertName) {
        this.keyVaultCertName = keyVaultCertName;
        return this;
    }

    /**
     * Get the certVersion property: The certificate version of key vault.
     *
     * @return the certVersion value.
     */
    public String certVersion() {
        return this.certVersion;
    }

    /**
     * Set the certVersion property: The certificate version of key vault.
     *
     * @param certVersion the certVersion value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withCertVersion(String certVersion) {
        this.certVersion = certVersion;
        return this;
    }

    /**
     * Get the excludePrivateKey property: Optional. If set to true, it will not import private key from key vault.
     *
     * @return the excludePrivateKey value.
     */
    public Boolean excludePrivateKey() {
        return this.excludePrivateKey;
    }

    /**
     * Set the excludePrivateKey property: Optional. If set to true, it will not import private key from key vault.
     *
     * @param excludePrivateKey the excludePrivateKey value to set.
     * @return the KeyVaultCertificateProperties object itself.
     */
    public KeyVaultCertificateProperties withExcludePrivateKey(Boolean excludePrivateKey) {
        this.excludePrivateKey = excludePrivateKey;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (vaultUri() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property vaultUri in model KeyVaultCertificateProperties"));
        }
        if (keyVaultCertName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property keyVaultCertName in model KeyVaultCertificateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultCertificateProperties.class);
}
