// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** Source with uploaded location. */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "type",
    defaultImpl = UploadedUserSourceInfo.class)
@JsonTypeName("UploadedUserSourceInfo")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "Jar", value = JarUploadedUserSourceInfo.class),
    @JsonSubTypes.Type(name = "Source", value = SourceUploadedUserSourceInfo.class),
    @JsonSubTypes.Type(name = "NetCoreZip", value = NetCoreZipUploadedUserSourceInfo.class)
})
@Fluent
public class UploadedUserSourceInfo extends UserSourceInfo {
    /*
     * Relative path of the storage which stores the source
     */
    @JsonProperty(value = "relativePath")
    private String relativePath;

    /**
     * Get the relativePath property: Relative path of the storage which stores the source.
     *
     * @return the relativePath value.
     */
    public String relativePath() {
        return this.relativePath;
    }

    /**
     * Set the relativePath property: Relative path of the storage which stores the source.
     *
     * @param relativePath the relativePath value to set.
     * @return the UploadedUserSourceInfo object itself.
     */
    public UploadedUserSourceInfo withRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public UploadedUserSourceInfo withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
