/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.ContainerProbeSettings;
import com.azure.resourcemanager.appplatform.models.Probe;
import com.azure.resourcemanager.appplatform.models.ResourceRequests;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class DeploymentSettings {
    @JsonProperty(value="resourceRequests")
    private ResourceRequests resourceRequests;
    @JsonProperty(value="environmentVariables")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> environmentVariables;
    @JsonProperty(value="addonConfigs")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, Map<String, Object>> addonConfigs;
    @JsonProperty(value="livenessProbe")
    private Probe livenessProbe;
    @JsonProperty(value="readinessProbe")
    private Probe readinessProbe;
    @JsonProperty(value="startupProbe")
    private Probe startupProbe;
    @JsonProperty(value="terminationGracePeriodSeconds")
    private Integer terminationGracePeriodSeconds;
    @JsonProperty(value="containerProbeSettings")
    private ContainerProbeSettings containerProbeSettings;

    public ResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public DeploymentSettings withResourceRequests(ResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public DeploymentSettings withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Map<String, Map<String, Object>> addonConfigs() {
        return this.addonConfigs;
    }

    public DeploymentSettings withAddonConfigs(Map<String, Map<String, Object>> addonConfigs) {
        this.addonConfigs = addonConfigs;
        return this;
    }

    public Probe livenessProbe() {
        return this.livenessProbe;
    }

    public DeploymentSettings withLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public Probe readinessProbe() {
        return this.readinessProbe;
    }

    public DeploymentSettings withReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public Probe startupProbe() {
        return this.startupProbe;
    }

    public DeploymentSettings withStartupProbe(Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    public Integer terminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public DeploymentSettings withTerminationGracePeriodSeconds(Integer terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    public ContainerProbeSettings containerProbeSettings() {
        return this.containerProbeSettings;
    }

    public DeploymentSettings withContainerProbeSettings(ContainerProbeSettings containerProbeSettings) {
        this.containerProbeSettings = containerProbeSettings;
        return this;
    }

    public void validate() {
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.livenessProbe() != null) {
            this.livenessProbe().validate();
        }
        if (this.readinessProbe() != null) {
            this.readinessProbe().validate();
        }
        if (this.startupProbe() != null) {
            this.startupProbe().validate();
        }
        if (this.containerProbeSettings() != null) {
            this.containerProbeSettings().validate();
        }
    }
}

