/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appplatform.models.AcceleratorAuthSetting;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AcceleratorGitRepository {
    @JsonProperty(value="url", required=true)
    private String url;
    @JsonProperty(value="intervalInSeconds")
    private Integer intervalInSeconds;
    @JsonProperty(value="branch")
    private String branch;
    @JsonProperty(value="commit")
    private String commit;
    @JsonProperty(value="gitTag")
    private String gitTag;
    @JsonProperty(value="authSetting", required=true)
    private AcceleratorAuthSetting authSetting;
    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorGitRepository.class);

    public String url() {
        return this.url;
    }

    public AcceleratorGitRepository withUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public AcceleratorGitRepository withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public AcceleratorGitRepository withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String commit() {
        return this.commit;
    }

    public AcceleratorGitRepository withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    public String gitTag() {
        return this.gitTag;
    }

    public AcceleratorGitRepository withGitTag(String gitTag) {
        this.gitTag = gitTag;
        return this;
    }

    public AcceleratorAuthSetting authSetting() {
        return this.authSetting;
    }

    public AcceleratorGitRepository withAuthSetting(AcceleratorAuthSetting authSetting) {
        this.authSetting = authSetting;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property url in model AcceleratorGitRepository"));
        }
        if (this.authSetting() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property authSetting in model AcceleratorGitRepository"));
        }
        this.authSetting().validate();
    }
}

