/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.resourcemanager.appplatform.models.ApmType;
import com.azure.resourcemanager.appplatform.models.GatewayApiMetadataProperties;
import com.azure.resourcemanager.appplatform.models.GatewayCorsProperties;
import com.azure.resourcemanager.appplatform.models.GatewayInstance;
import com.azure.resourcemanager.appplatform.models.GatewayOperatorProperties;
import com.azure.resourcemanager.appplatform.models.GatewayPropertiesClientAuth;
import com.azure.resourcemanager.appplatform.models.GatewayPropertiesEnvironmentVariables;
import com.azure.resourcemanager.appplatform.models.GatewayProvisioningState;
import com.azure.resourcemanager.appplatform.models.GatewayResourceRequests;
import com.azure.resourcemanager.appplatform.models.SsoProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GatewayProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private GatewayProvisioningState provisioningState;
    @JsonProperty(value="public")
    private Boolean publicProperty;
    @JsonProperty(value="url", access=JsonProperty.Access.WRITE_ONLY)
    private String url;
    @JsonProperty(value="httpsOnly")
    private Boolean httpsOnly;
    @JsonProperty(value="ssoProperties")
    private SsoProperties ssoProperties;
    @JsonProperty(value="apiMetadataProperties")
    private GatewayApiMetadataProperties apiMetadataProperties;
    @JsonProperty(value="corsProperties")
    private GatewayCorsProperties corsProperties;
    @JsonProperty(value="clientAuth")
    private GatewayPropertiesClientAuth clientAuth;
    @JsonProperty(value="apmTypes")
    private List<ApmType> apmTypes;
    @JsonProperty(value="environmentVariables")
    private GatewayPropertiesEnvironmentVariables environmentVariables;
    @JsonProperty(value="resourceRequests")
    private GatewayResourceRequests resourceRequests;
    @JsonProperty(value="instances", access=JsonProperty.Access.WRITE_ONLY)
    private List<GatewayInstance> instances;
    @JsonProperty(value="operatorProperties", access=JsonProperty.Access.WRITE_ONLY)
    private GatewayOperatorProperties operatorProperties;

    public GatewayProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean publicProperty() {
        return this.publicProperty;
    }

    public GatewayProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    public String url() {
        return this.url;
    }

    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    public GatewayProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    public SsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    public GatewayProperties withSsoProperties(SsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    public GatewayApiMetadataProperties apiMetadataProperties() {
        return this.apiMetadataProperties;
    }

    public GatewayProperties withApiMetadataProperties(GatewayApiMetadataProperties apiMetadataProperties) {
        this.apiMetadataProperties = apiMetadataProperties;
        return this;
    }

    public GatewayCorsProperties corsProperties() {
        return this.corsProperties;
    }

    public GatewayProperties withCorsProperties(GatewayCorsProperties corsProperties) {
        this.corsProperties = corsProperties;
        return this;
    }

    public GatewayPropertiesClientAuth clientAuth() {
        return this.clientAuth;
    }

    public GatewayProperties withClientAuth(GatewayPropertiesClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public List<ApmType> apmTypes() {
        return this.apmTypes;
    }

    public GatewayProperties withApmTypes(List<ApmType> apmTypes) {
        this.apmTypes = apmTypes;
        return this;
    }

    public GatewayPropertiesEnvironmentVariables environmentVariables() {
        return this.environmentVariables;
    }

    public GatewayProperties withEnvironmentVariables(GatewayPropertiesEnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public GatewayResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    public GatewayProperties withResourceRequests(GatewayResourceRequests resourceRequests) {
        this.resourceRequests = resourceRequests;
        return this;
    }

    public List<GatewayInstance> instances() {
        return this.instances;
    }

    public GatewayOperatorProperties operatorProperties() {
        return this.operatorProperties;
    }

    public void validate() {
        if (this.ssoProperties() != null) {
            this.ssoProperties().validate();
        }
        if (this.apiMetadataProperties() != null) {
            this.apiMetadataProperties().validate();
        }
        if (this.corsProperties() != null) {
            this.corsProperties().validate();
        }
        if (this.clientAuth() != null) {
            this.clientAuth().validate();
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().validate();
        }
        if (this.resourceRequests() != null) {
            this.resourceRequests().validate();
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.operatorProperties() != null) {
            this.operatorProperties().validate();
        }
    }
}

