// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** API portal properties payload. */
@Fluent
public final class ApiPortalProperties {
    /*
     * State of the API portal.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ApiPortalProvisioningState provisioningState;

    /*
     * Indicates whether the API portal exposes endpoint.
     */
    @JsonProperty(value = "public")
    private Boolean publicProperty;

    /*
     * URL of the API portal, exposed when 'public' is true.
     */
    @JsonProperty(value = "url", access = JsonProperty.Access.WRITE_ONLY)
    private String url;

    /*
     * Indicate if only https is allowed.
     */
    @JsonProperty(value = "httpsOnly")
    private Boolean httpsOnly;

    /*
     * The array of resource Ids of gateway to integrate with API portal.
     */
    @JsonProperty(value = "gatewayIds")
    private List<String> gatewayIds;

    /*
     * Collection of OpenAPI source URL locations.
     */
    @JsonProperty(value = "sourceUrls")
    private List<String> sourceUrls;

    /*
     * Single sign-on related configuration
     */
    @JsonProperty(value = "ssoProperties")
    private SsoProperties ssoProperties;

    /*
     * The requested resource quantity for required CPU and Memory.
     */
    @JsonProperty(value = "resourceRequests", access = JsonProperty.Access.WRITE_ONLY)
    private ApiPortalResourceRequests resourceRequests;

    /*
     * Collection of instances belong to API portal.
     */
    @JsonProperty(value = "instances", access = JsonProperty.Access.WRITE_ONLY)
    private List<ApiPortalInstance> instances;

    /**
     * Get the provisioningState property: State of the API portal.
     *
     * @return the provisioningState value.
     */
    public ApiPortalProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publicProperty property: Indicates whether the API portal exposes endpoint.
     *
     * @return the publicProperty value.
     */
    public Boolean publicProperty() {
        return this.publicProperty;
    }

    /**
     * Set the publicProperty property: Indicates whether the API portal exposes endpoint.
     *
     * @param publicProperty the publicProperty value to set.
     * @return the ApiPortalProperties object itself.
     */
    public ApiPortalProperties withPublicProperty(Boolean publicProperty) {
        this.publicProperty = publicProperty;
        return this;
    }

    /**
     * Get the url property: URL of the API portal, exposed when 'public' is true.
     *
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the httpsOnly property: Indicate if only https is allowed.
     *
     * @return the httpsOnly value.
     */
    public Boolean httpsOnly() {
        return this.httpsOnly;
    }

    /**
     * Set the httpsOnly property: Indicate if only https is allowed.
     *
     * @param httpsOnly the httpsOnly value to set.
     * @return the ApiPortalProperties object itself.
     */
    public ApiPortalProperties withHttpsOnly(Boolean httpsOnly) {
        this.httpsOnly = httpsOnly;
        return this;
    }

    /**
     * Get the gatewayIds property: The array of resource Ids of gateway to integrate with API portal.
     *
     * @return the gatewayIds value.
     */
    public List<String> gatewayIds() {
        return this.gatewayIds;
    }

    /**
     * Set the gatewayIds property: The array of resource Ids of gateway to integrate with API portal.
     *
     * @param gatewayIds the gatewayIds value to set.
     * @return the ApiPortalProperties object itself.
     */
    public ApiPortalProperties withGatewayIds(List<String> gatewayIds) {
        this.gatewayIds = gatewayIds;
        return this;
    }

    /**
     * Get the sourceUrls property: Collection of OpenAPI source URL locations.
     *
     * @return the sourceUrls value.
     */
    public List<String> sourceUrls() {
        return this.sourceUrls;
    }

    /**
     * Set the sourceUrls property: Collection of OpenAPI source URL locations.
     *
     * @param sourceUrls the sourceUrls value to set.
     * @return the ApiPortalProperties object itself.
     */
    public ApiPortalProperties withSourceUrls(List<String> sourceUrls) {
        this.sourceUrls = sourceUrls;
        return this;
    }

    /**
     * Get the ssoProperties property: Single sign-on related configuration.
     *
     * @return the ssoProperties value.
     */
    public SsoProperties ssoProperties() {
        return this.ssoProperties;
    }

    /**
     * Set the ssoProperties property: Single sign-on related configuration.
     *
     * @param ssoProperties the ssoProperties value to set.
     * @return the ApiPortalProperties object itself.
     */
    public ApiPortalProperties withSsoProperties(SsoProperties ssoProperties) {
        this.ssoProperties = ssoProperties;
        return this;
    }

    /**
     * Get the resourceRequests property: The requested resource quantity for required CPU and Memory.
     *
     * @return the resourceRequests value.
     */
    public ApiPortalResourceRequests resourceRequests() {
        return this.resourceRequests;
    }

    /**
     * Get the instances property: Collection of instances belong to API portal.
     *
     * @return the instances value.
     */
    public List<ApiPortalInstance> instances() {
        return this.instances;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ssoProperties() != null) {
            ssoProperties().validate();
        }
        if (resourceRequests() != null) {
            resourceRequests().validate();
        }
        if (instances() != null) {
            instances().forEach(e -> e.validate());
        }
    }
}
